<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanyModel extends Model
{
    use HasFactory;

    protected $table = 'company';
    public $timestamps = true;

    protected $primaryKey = 'id';

    protected $fillable = [
        'name',
        'address',
        'phone',
        'email',
        'prefix',
        'logo',
        'application_name'
    ];

    /**
     * Get all users associated with the company.
     */
    public function users()
    {
        return $this->belongsToMany(User::class, 'company_user', 'company_id', 'user_id');
    }

    /**
     * Get all branches for the company.
     */
    public function branches()
    {
        return $this->hasMany(BranchModel::class);
    }
}
