<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvoiceItemTaxModel extends Model
{
    use HasFactory;
    protected $table = 'invoice_item_taxes';
    public $timestamps = true;

    protected $primaryKey = 'id';
    protected $fillable = [
        'invoice_item_id',
        'tax_id',
        'tax',
    ];

    public function invoiceItem()
    {
        return $this->belongsTo(InvoiceItemModel::class, 'invoice_item_id');
    }
    public function taxes()
    {
        return $this->belongsTo(TaxesModel::class, 'tax_id');
    }
}