@extends('layouts.layoutapp')
@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card me-2">
                <form id="importForm" action="{{ route('client-import') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="card-header d-flex justify-content-between">
                        <div class="card-title">
                            <h4>Client Import</h4>
                        </div>
                        <div>
                            <a href="{{route('client-template')}}" class="btn btn-primary">
                                Download Template
                            </a>
                            <a href="{{route('client-index')}}" class="btn btn-secondary">Back</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row align-items-center"> <!-- Added align-items-center here -->
                            <!-- First Column -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Upload File</label>
                                    <input type="file" name="file" class="form-control" id="fileInput" required>
                                </div>
                            </div>
                            <!-- Second Column -->
                            <div class="col-md-6">
                                <div class="mb-3 mt-5">

                                    <button class="btn bg-gradient-primary" type="submit">Upload</button>
                                </div>
                            </div>
                        </div>
                        <!-- Second Column -->
                        <div class="col-md-6">
                            <div class="mb-3">
                                @if (session('client_import_error'))

                                    <ul class="mt-4">
                                        @foreach (session('client_import_error') as $error)
                                            <li class="text-danger">{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                @else
                                    <p class="mt-4">No errors found.</p>
                                @endif
                            </div>
                        </div>

                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection