@extends('layouts.layoutapp')

@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <!-- Card Header -->
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">Invoices EMI</h5>
                            </div>
                            <a href="{{ route('invoice-emi-add') }}" class="btn bg-gradient-primary btn-sm mb-0">+&nbsp; New
                                Invoice EMI</a>
                        </div>
                    </div>
                    <div class="card-body px-0 pt-0 pb-2">

                        <div class="table-responsive p-0">
                            <table class="table align-items-center mb-0 table-hover" id="myTable">
                                <thead>
                                    <tr>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            ID</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Client</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Invoice Date</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Due Date</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Amount</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Transactions</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Status</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($invoices as $data)
                                                                    <tr>
                                                                        <td>
                                                                            <p class="text-xs font-weight-bold mb-0">{{ $data->invoice_id ?? '' }}</p>
                                                                        </td>
                                                                        <td>
                                                                            <p class="text-xs font-weight-bold mb-0">
                                                                                {{ $data->client->user->name }} {{ $data->client->user->last_name ?? '' }}
                                                                            </p>
                                                                        </td>
                                                                        <td>
                                                                            <p class="text-xs font-weight-bold mb-0">
                                                                                {{ $data->invoice_date ? \Carbon\Carbon::parse($data->invoice_date)->format('d-m-Y') : '' }}
                                                                            </p>
                                                                        </td>
                                                                        <td>
                                                                            <p class="text-xs font-weight-bold mb-0">
                                                                                {{ $data->due_date ? \Carbon\Carbon::parse($data->due_date)->format('d-m-Y') : '' }}
                                                                            </p>
                                                                        </td>
                                                                        <td>
                                                                            <p class="text-xs font-weight-bold mb-0">
                                                                                {{ max($data->final_amount ?? '', 2) }}
                                                                            </p>
                                                                        </td>
                                                                        <td>
                                                                            <p class="text-xs font-weight-bold mb-0">0</p>
                                                                        </td>
                                                                        <td>
                                                                            @php
                                                                                $status = optional($payment_status->firstWhere('id', $data->status))->name ?? 'Unpaid';
                                                                                $badgeClass = [
                                                                                    'Paid' => 'badge bg-success',
                                                                                    'Unpaid' => 'badge bg-danger',
                                                                                    'Partially Paid' => 'badge bg-warning ',
                                                                                ][$status] ?? 'badge bg-light text-dark';
                                                                            @endphp
                                                                            <span class="{{ $badgeClass }}">{{ $status }}</span>
                                                                        </td>
                                                                        <td>
                                                                            <a href="{{ route('invoice-emi-edit', $data->id) }}">
                                                                                <i class="fa-solid fa-eye text-secondary ms-2"></i>
                                                                            </a>
                                                                            <form action="{{ route('invoice-emi-delete', $data->id) }}" method="POST" class="d-inline" id="deleteform-{{$data->id}}">
                                                                                @csrf
                                                                                @method('DELETE')
                                                                                
                                                                                <i class="cursor-pointer fas fa-trash text-secondary ms-2" onclick="confirmDelete({{ $data->id }})"></i>
                                                                            </form>                                                                                                                                                
                                                                            
                                                                            <a href="{{ route('invoice-emi-payment', $data->id) }}">
                                                                                <i class="fa-solid fa-clipboard text-secondary ms-2"></i>
                                                                            </a>
                                                                        </td>
                                                                    </tr>                                  
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
    function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('deleteform-' + id).submit();  // Corrected ID
            }
        });
    }
</script>
@endpush