@extends('layouts.layoutapp')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card me-2">
                <div class="card-header pb-0">
                    <div class="d-flex flex-row justify-content-between">
                        <div>
                            <h5 class="mb-0">Update Payment</h5>
                        </div>
                        <span class="badge bg-primary extra_amount" style="display: none;">Extra Amount: ₹ 0.00</span>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('invoice-payment-update') }}" method="POST">
                        @csrf
                        <input type="hidden" name="id" value="{{$payment->id}}">
                        <div class="row">
                            <div class="col-lg-4 mb-4">
                                <label for="invoice" class="form-label">Invoice:</label>
                                <select class="form-select" id="invoice" name="invoice" disabled>
                                    <option value="{{ $invoice->id }}" selected>
                                        {{ $invoice->invoice_id }} - {{ $invoice->client->user->phone ?? '' }}
                                    </option>
                                </select>
                                <input type="hidden" name="invoice" value="{{ $invoice->id }}">
                            </div>
                            <div class="col-lg-4 mb-4">
                                <label for="totalAmount" class="form-label">Total Amount:</label>
                                <input type="text" id="totalAmount" class="form-control" name="totalAmount"
                                    value="{{ old('totalAmount', $invoice->final_amount) }}" readonly>
                            </div>
                            <div class="col-lg-4 mb-4">
                                <label for="dueAmount" class="form-label">Due Amount:</label>
                                <input type="text" id="dueAmount" class="form-control" name="dueAmount"
                                    value="{{ old('dueAmount', $dueAmount) }}" readonly>
                            </div>
                            <div class="col-lg-4 mb-4">
                                <label for="paidAmount" class="form-label">Paid Amount</label>
                                <input type="text" id="paidAmount" class="form-control" name="paidAmount"
                                    value="{{ old('paidAmount', $totalPaidAmount) }}" readonly>
                            </div>

                            <div class="col-lg-4 mb-4">
                                <label for="paymentDate" class="form-label">Payment Date</label>
                                <input type="date" id="paymentDate" class="form-control" name="paymentDate"
                                    value="{{ old('paymentDate', $payment->payment_date ?? now()->toDateString()) }}"
                                    required>
                                @error('paymentDate') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="col-lg-4 mb-4">
                                <label for="paymentMethod" class="form-label">Payment Method</label>
                                <select name="paymentMethod" id="paymentMethod" class="form-select" required>
                                    <option value="">Select Payment Method</option>
                                    @foreach ($payment_mode as $item)
                                        <option value="{{$item->id}}">{{$item->name}}</option>
                                    @endforeach
                                </select>
                                @error('paymentMethod') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="col-lg-4 mb-4" id="tenderedAmountContainer" style="display: none;">
                                <label for="tendered_amount" class="form-label">Tendered Amount</label>
                                <input type="number" step="0.01" name="tendered_amount" id="tendered_amount"
                                    class="form-control" value="{{ old('tendered_amount') }}"
                                    placeholder="Enter tendered amount">
                                @error('tendered_amount')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-4 mb-4">
                                <label for="amount" class="form-label">Amount</label>
                                <input type="number" step="0.01" id="amount" class="form-control" name="amount"
                                    value="{{ old('amount') }}" required>
                                @error('amount') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="col-lg-4 mb-4">
                                <label for="note" class="form-label">Note:</label>
                                <textarea id="note" class="form-control" name="note"
                                    rows="1">{{ old('note', $payment->notes ?? '') }}</textarea>
                                @error('note') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                        </div>

                        <div class="table-responsive p-0 mb-4">
                            <table class="table align-items-center mb-0">
                                <thead>
                                    <tr>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Invoices
                                        </th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Payment Date
                                        </th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Amount
                                        </th>
                                        <th
                                            class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7">
                                            Payment Method
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $cumulativeTotal = 0;
                                    @endphp

                                    @forelse ($paymentsForInvoice as $data)
                                        <tr>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">{{ $data->invoice->invoice_id }}
                                                </p>
                                            </td>
                                            <td class="ps-4">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    {{ \Carbon\Carbon::parse($data->payment_date)->format('d/m/Y') }}
                                                </p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">{{ $data->amount }}</p>
                                            </td>
                                            <td class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">
                                                    {{ \App\Models\PaymentsModel::PAYMENT_MODE[$data->payment_mode] ?? 'Unknown' }}
                                                </p>
                                            </td>
                                        </tr>
                                        @php
                                            $cumulativeTotal += $data->amount;
                                        @endphp
                                    @empty
                                        <tr>
                                            <td colspan="5" class="text-center">
                                                <p class="text-xs font-weight-bold mb-0">No Payments found.</p>
                                            </td>
                                        </tr>
                                    @endforelse

                                    @if($cumulativeTotal > 0)
                                        <tr>
                                            <td colspan="2" class="text-end text-xs font-weight-bold">Total Amount:</td>
                                            <td class="text-center text-xs font-weight-bold">{{ $cumulativeTotal }}</td>
                                            <td colspan="2"></td>
                                        </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>

                        <div class="d-flex justify-content-end">
                            <button type="submit" class="btn btn-primary me-2">Update Payment</button>
                            <a href="{{ route('invoice-payment-index') }}" class="btn btn-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        $(document).ready(function () {

            $('#paymentMethod').on('change', function () {
                const selectedText = $('#paymentMethod option:selected').text().toLowerCase();
                if (selectedText.includes('cash')) {
                    $('#tenderedAmountContainer').show();
                } else {
                    $('#tenderedAmountContainer').hide();
                    $('.extra_amount').hide();
                    $('#tendered_amount').val('');
                    $('#amount').val($('#amount').data('original') || 0);
                    $('.extra_amount').text('Extra Amount: ₹ 0.00');
                }
            });

            $('#amount').data('original', parseFloat($('#amount').val()) || 0);

            function calculatePaymentBreakdown() {
                let total_amount = parseFloat($('#totalAmount').val()) || 0;
                let paid_amount = parseFloat($('#paidAmount').val()) || 0;

                let tendered_amount = parseFloat($('#tendered_amount').val()) || 0;

                let remaining_amount = total_amount - paid_amount;

                let extra_amount = 0;
                let paying_amount = tendered_amount;

                if (tendered_amount > remaining_amount) {
                    extra_amount = tendered_amount - remaining_amount;
                    paying_amount = remaining_amount;
                }

                $('.extra_amount').text('Extra Amount: ₹ ' + extra_amount.toFixed(2));
                $('#amount').val(paying_amount.toFixed(2));
            }

            $(document).on('input', '#tendered_amount', calculatePaymentBreakdown);

            if ($('#tendered_amount').val()) {
                calculatePaymentBreakdown();
            }
        });
    </script>
@endpush