

<?php $__env->startSection('content'); ?>
<div class="main-content">
    <div class="row">
        <div class="col-12">
            <div class="card mb-4 mx-4">
                <div class="card-header pb-0">
                    <div class="d-flex flex-row justify-content-between">
                        <div>
                            <h5 class="mb-0">Edit Expense</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('expense-update')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="id" value="<?php echo e($expense->id); ?>">
                        <input type="hidden" name="expense_category_id" value="<?php echo e($expense->expense_category_id); ?>">
                        <div class="row">
                            <div class="col-lg-6 mb-3">
                                <label for="category" class="form-label">Category:</label>
                                <select class="form-select" name="expense_category_id" disabled>
                                    <option value="" selected>Select Category</option>
                                    <?php $__currentLoopData = $expense_category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>" 
                                            <?php echo e(old('expense_category_id', $expense->expense_category_id) == $category->id ? 'selected' : ''); ?>>
                                            <?php echo e($category->category_name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['expense_category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> 
                                    <span class="text-danger"><?php echo e($message); ?></span> 
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div> 
                            <div class="col-lg-6 mb-3">
                                <label for="expenseName" class="form-label">Expense Name:</label>
                                <input type="text" id="expenseName" class="form-control" placeholder="Enter Expense Name" 
                                       name="expense_name" value="<?php echo e(old('expense_name', $expense->expense_name)); ?>" required>
                                <?php $__errorArgs = ['expense_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> 
                                    <span class="text-danger"><?php echo e($message); ?></span> 
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-lg-6 mb-3">
                                <label for="expenseAmount" class="form-label">Amount:</label>
                                <input type="text" id="expenseAmount" class="form-control"  placeholder="Enter Expense Amount"
                                       name="expense_amount" value="<?php echo e(old('expense_amount', $expense->expense_amount)); ?>" required>
                                <?php $__errorArgs = ['expense_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> 
                                    <span class="text-danger"><?php echo e($message); ?></span> 
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-lg-6 mb-3">
                                <label for="expense_date" class="form-label">Expense Date:</label>
                                <input type="date" id="expense_date" class="form-control" 
                                       name="expense_date" value="<?php echo e(old('expense_date', $expense->expense_date)); ?>">
                                <?php $__errorArgs = ['expense_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> 
                                    <span class="text-danger"><?php echo e($message); ?></span> 
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            
                            <div class="col-12 mb-3">
                                <label for="attachment" class="form-label">Attachment:</label>
                                <div class="d-flex align-items-center">
                                    <div class="avatar-upload me-5">
                                        <div class="avatar-preview">
                                            <?php if($expense->expense_attachment): ?>
                                                <?php
                                                    $fileExtension = pathinfo($expense->expense_attachment, PATHINFO_EXTENSION);
                                                    $isImage = in_array(strtolower($fileExtension), ['jpg', 'jpeg', 'png', 'gif', 'bmp']);
                                                ?>
                                                
                                                <?php if($isImage): ?>
                                                 <a href="<?php echo e(getFileUrl($expense->expense_attachment)); ?>" target="_blank">
                                                    <img src="<?php echo e(getFileUrl($expense->expense_attachment)); ?>" 
                                                         alt="Attachment Preview" class="img-fluid" style="height:50px; width:50px">
                                                 </a>
                                                <?php elseif(strtolower($fileExtension) === 'pdf'): ?>
                                                    <a href="<?php echo e(getFileUrl($expense->expense_attachment)); ?>" target="_blank">
                                                        <img src="<?php echo e(asset('assets/img/logos/pdf.png')); ?>" 
                                                             alt="PDF Preview" class="img-fluid" style="height:50px; width:50px">
                                                    </a>
                                                <?php else: ?>
                                                    <a href="<?php echo e(getFileUrl($expense->expense_attachment)); ?>" target="_blank">
                                                        <img src="<?php echo e(asset('assets/img/logos/file.png')); ?>" 
                                                             alt="File Preview" class="img-fluid" style="height:50px; width:50px">
                                                    </a>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <img src="<?php echo e(asset('assets/img/logos/attach.png')); ?>" 
                                                     alt="Default Attachment" class="img-fluid" style="height:50px; width:50px">
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="avatar-edit">
                                        <input type="file" id="attachment" class="form-control file-upload-input" 
                                               name="attachment" accept="image/*,application/pdf" onchange="previewFile(this)">
                                    </div>
                                </div>
                                <?php $__errorArgs = ['attachment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="d-flex justify-content-end mt-4">
                            <button type="submit" class="btn btn-primary me-2">Update Expense</button>
                            <a href="<?php echo e(route('expense-index')); ?>" class="btn btn-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    function previewFile(input) {
        const preview = document.querySelector('.avatar-preview img');
        const file = input.files[0];
        
        if (file) {
            const reader = new FileReader();

            reader.onloadend = function () {
                if (file.type.includes('image')) {
                    preview.src = reader.result;
                } else if (file.type.includes('pdf')) {
                    preview.src = "<?php echo e(asset('assets/img/logos/pdf.png')); ?>";
                } else {
                    preview.src = "<?php echo e(asset('assets/img/logos/file.png')); ?>";
                }
            }

            reader.readAsDataURL(file);
        } else {
            // If no file selected, show current attachment or default
            <?php if($expense->expense_attachment): ?>
                <?php
                    $fileExtension = pathinfo($expense->expense_attachment, PATHINFO_EXTENSION);
                    $isImage = in_array(strtolower($fileExtension), ['jpg', 'jpeg', 'png', 'gif', 'bmp']);
                ?>
                
                <?php if($isImage): ?>
                    preview.src = "<?php echo e(getFileUrl($expense->expense_attachment)); ?>";
                <?php elseif(strtolower($fileExtension) === 'pdf'): ?>
                    preview.src = "<?php echo e(asset('assets/img/logos/pdf.png')); ?>";
                <?php else: ?>
                    preview.src = "<?php echo e(asset('assets/img/logos/file.png')); ?>";
                <?php endif; ?>
            <?php else: ?>
                preview.src = "<?php echo e(asset('assets/img/logos/attach.png')); ?>";
            <?php endif; ?>
        }
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/expenses/edit.blade.php ENDPATH**/ ?>