

<?php $__env->startSection('content'); ?>

  <div class="row">
        <div class="col-12">
    <div class="card me-2">
        <div class="card-body">
            <div class="d-flex justify-content-end align-items-center mb-3 px-3">
                <form method="GET" action="<?php echo e(route('invoice-emi-Report')); ?>" class="d-flex align-items-center">
                    <div class="form-group me-3">
                        <input type="date" class="form-control <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            id="start_date" name="start_date"
                            value="<?php echo e(old('start_date', request()->get('start_date'))); ?>">

                        <!-- Display error message for start_date -->
                        <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback">
                                <?php echo e($message); ?>

                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group me-3">
                        <input type="date" class="form-control <?php $__errorArgs = ['end_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="end_date"
                            name="end_date" value="<?php echo e(old('end_date', request()->get('end_date'))); ?>">

                        <!-- Display error message for end_date -->
                        <?php $__errorArgs = ['end_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback">
                                <?php echo e($message); ?>

                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group me-3">

                        <select name="status" id="status" class="form-control">
                            <option value="">Filters</option>
                            <option value=" " <?php echo e(request()->get('status') == 'all' ? 'selected' : ''); ?>>All</option>
                            <option value="Y" <?php echo e(request()->get('status') == 'gst' ? 'selected' : ''); ?>>GST</option>
                            <option value="N" <?php echo e(request()->get('status') == 'non_gst' ? 'selected' : ''); ?>>Non-GST
                            </option>

                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary">Filter</button>
                </form>
            </div>

            <div class="table-responsive">
                <table class="table align-items-center mb-0 table-hover text-sm" id="myTable">
                    <thead>
                        <tr>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Invoice ID
                            </th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Client Name
                            </th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Branch Name
                            </th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Invoice Date
                            </th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Due Date
                            </th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">GST</th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Tax</th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Discount
                                type</th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Discount
                            </th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Final Amount
                            </th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Down Payment
                            </th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">EMI
                                Percentage</th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">EMI Amount
                            </th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">EMI Base
                                Amount</th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">EMI Discount
                            </th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Penalty
                                Amount</th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Paid Amount
                            </th>

                            
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>                        
                                                <tr>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0"><?php echo e($data->invoice_id ?? ''); ?></p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0">
                                                            <?php echo e($data->client ? $data->client->user->name : ''); ?>

                                                        </p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0"><?php echo e($data->branch->name ?? ''); ?></p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0">
                                                            <?php echo e($data->invoice_date ? \Carbon\Carbon::parse($data->invoice_date)->format('d-m-Y') : ''); ?>

                                                        </p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0">
                                                            <?php echo e($data->due_date ? \Carbon\Carbon::parse($data->due_date)->format('d-m-Y') : ''); ?>

                                                        </p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0"><?php echo e($data->gst == 'Y' ? 'Yes' : 'No'); ?></p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <?php
                                                            $taxDetails = [];
                                                            foreach ($data->invoiceItems as $item) {
                                                                foreach ($item->invoiceItemTaxes as $taxes) {
                                                                    $taxName = $taxes->taxes->name;
                                                                    if (!isset($taxDetails[$taxName])) {
                                                                        $taxDetails[$taxName] = 0;
                                                                    }
                                                                    $taxDetails[$taxName] = $taxes->tax;
                                                                }
                                                            }
                                                        ?>
                                                    
                                                        <ul style="list-style-type: none; padding-left: 0;">
                                                            <?php if(count($taxDetails)): ?>
                                                                <?php $__currentLoopData = $taxDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <li class="text-xs font-weight-bold mb-0">
                                                                        <?php echo e($name); ?>: <?php echo e(number_format($value, 2)); ?>

                                                                    </li>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php else: ?>
                                                                <li class="text-xs font-weight-bold mb-0">No tax available</li>
                                                            <?php endif; ?>
                                                        </ul>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0">
                                                            <?php echo e($data->discount_type === null ? 'Not Set' : ($data->discount_type == 1 ? 'Fixed' : 'Percentage')); ?>

                                                        </p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0"><?php echo e($data->discount ?? ''); ?></p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0"><?php echo e($data->final_amount ?? ''); ?></p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0"><?php echo e($data->invoice_emi->down_payment ?? ''); ?>

                                                        </p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0"><?php echo e($data->invoice_emi->intersest_rate ?? ''); ?>

                                                        </p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0"><?php echo e($data->invoice_emi->emi_amount ?? ''); ?></p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0"><?php echo e($data->invoice_emi->actual_amount ?? ''); ?>

                                                        </p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <?php
                                                            if ($data->invoice_emi) {
                                                                $discount = 0;
                                                                foreach ($data->invoice_emi->invoice_emi_dtls as $emiDetail) {
                                                                    $discount += $emiDetail->discount_amount;
                                                                }
                                                            }
                                                        ?>
                                                        <p class="text-xs font-weight-bold mb-0"><?php echo e($discount ?? ''); ?></p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <?php                                                       
                                                                                                                                                                                                                                                                if ($data->invoice_emi) {
                                                                $penalty = 0;
                                                                foreach ($data->invoice_emi->invoice_emi_dtls as $emiDetail) {
                                                                    $penalty += is_numeric($emiDetail->penalty) ? (int) $emiDetail->penalty : 0;
                                                                }
                                                            }
                                                        ?><p class="text-xs font-weight-bold mb-0"> <?php echo e($penalty ?? ''); ?> </p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <?php
                                                            if ($data->invoice_emi) {
                                                                $finalAmount = 0;
                                                                foreach ($data->invoice_emi->invoice_emi_dtls as $emiDetail) {
                                                                    $finalAmount += $emiDetail->total_amount;
                                                                }
                                                            }
                                                        ?>
                                                        <p class="text-xs font-weight-bold mb-0"><?php echo e($finalAmount ?? ''); ?></p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <a href="#" data-bs-toggle="modal" data-bs-target="#emiModal" data-id="<?php echo e($data->id); ?>">
                                                            <i class="fa-solid fa-eye"></i>
                                                        </a>
                                                    </td>
                                                </tr>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>
            </div>
        </div>
    </div>
        </div>

<div class="modal fade" id="emiModal" tabindex="-1" aria-labelledby="emiModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="emiModalLabel"></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body table-responsive">
                <table class="table table-bordered text-center text-sm">
                    <thead>
                        <tr>
                            <th>Emi Date</th>
                            <th>EMI Amount</th>
                            <th>Paid Date</th>
                            
                            <th>Due Days</th>
                            <th>Penalty Amount</th>
                            <th>Discount Amount</th>
                            <th>Paid Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                    <tfoot>
                    </tfoot>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
    document.getElementById('emiModal').addEventListener('show.bs.modal', function (event) {
        var button = event.relatedTarget;
        var id = button.getAttribute('data-id');

        fetch('/get-invoice-details/' + id)
            .then(response => response.json())
            .then(data => {
                document.getElementById('emiModalLabel').textContent = 'Invoice EMI Report: ' + data.invoice_number;

                var tbody = document.querySelector('#emiModal .modal-body table tbody');
                tbody.innerHTML = '';
                let totalPaidAmount = 0;

                data.emi_details.forEach(function (product) {
                    var row = document.createElement('tr');
                    var emiDate = product.emi_date ? new Date(product.emi_date) : null;
                    var paidDate = product.paid_date ? new Date(product.paid_date) : null;
                    var formattedEmiDate = emiDate ?
                        (emiDate.getDate() + '/' + String(emiDate.getMonth() + 1).padStart(2, '0') + '/' + emiDate.getFullYear())
                        : '0';

                    var formattedPaidDate = paidDate ?
                        (paidDate.getDate() + '/' + String(paidDate.getMonth() + 1).padStart(2, '0') + '/' + paidDate.getFullYear())
                        : '0';

                    var totalAmount = product.total_amount ? parseFloat(product.total_amount.replace(/[^\d.-]/g, '')) : 0;
                    totalPaidAmount += totalAmount;
                    row.innerHTML = '<td>' + formattedEmiDate + '</td>' +
                        '<td>₹ ' + (product.emi_amount || 0) + '</td>' +
                        '<td>' + formattedPaidDate + '</td>' +
                        '<td>' + (product.due_days || 0) + '</td>' +
                        '<td>₹ ' + (product.penalty || 0) + '</td>' +
                        '<td>₹ ' + (product.discount_amount || 0) + '</td>' +
                        '<td>₹ ' + (product.total_amount || 0) + '</td>';
                    tbody.appendChild(row);
                });

                var modalFooter = document.querySelector('#emiModal .modal-body table tfoot');
                modalFooter.innerHTML = '';

                var totalPaidRow = document.createElement('tr');
                totalPaidRow.innerHTML = `
                <td colspan="6" class="text-end"><strong>Total Paid Amount: </strong></td>
                <td><strong>₹ ${totalPaidAmount}</strong></td>
            `;
                modalFooter.appendChild(totalPaidRow);
            })
            .catch(error => {
                console.error('Error:', error);
            });
    });

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/reports/invoiceEmiReport.blade.php ENDPATH**/ ?>