<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class Ordercreated extends Mailable
{
    use Queueable, SerializesModels;

    protected $pdfData;
    protected $order;
    protected $settings;

    public function __construct($pdfData, $order, $settings)
    {
        $this->pdfData = $pdfData;
        $this->order = $order;
        $this->settings = $settings;
    }

    public function build()
    {
        return $this->subject('New Order Created - #' . $this->order->order_id)
            ->view('mail.order-created', [
                'order' => $this->order,
                'settings' => $this->settings,
            ])
            ->attachData($this->pdfData, 'order_' . $this->order->order_id . '.pdf', [
                'mime' => 'application/pdf',
            ]);
    }
}
