<?php

namespace App\Providers;

use App\Models\WhatsappConfigModel;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class WhatsAppService
{
    protected $apiUrl;
    protected $accessToken;
    protected $phoneNumberId;

    public function __construct()
    {
        $whatsapp_config = WhatsappConfigModel::first();
        $this->apiUrl = $whatsapp_config->whatsapp_api_url;
        $this->accessToken = $whatsapp_config->whatsapp_access_token;
        $this->phoneNumberId = $whatsapp_config->whatsapp_phone_number_id;
    }

   public function sendWhatsAppMessage($phone, $invoiceNumber, $amount)
{
    try {
     $response = Http::withHeaders([
    'Content-Type'       => 'application/json',
    'Accept'             => 'application/json',
    'Authorization'      => 'Bearer BgOnmC2tELoYDJeAOeSaHN57lNS3h5EI3V2t5pK3q6',
    'X-MYOP-COMPANY-ID'  => '68ba8e81505b4759',
])->post('https://publicapi.myoperator.co/chat/messages', [
    "phone_number_id"       => "811718185351375",   // e.g. 811718185351375
    "customer_country_code" => "91",
    "customer_number"       => $phone,
    "data" => [
        "type"     => "template",
        "language" => "en",
        "context"  => [
            "template_name" => "invoice_11",
            "language"      => "en",
            "body" => [
                "1" => $phone,
                "2" => $invoiceNumber,
                "3" => $amount
            ]
        ]
    ],
    "reply_to"   => null,
    "myop_ref_id" => uniqid("INV_") // Dynamic unique ID
]);
        $responseBody = $response->json();

        Log::info("WhatsApp Response", $responseBody);

        if (!$response->successful()) {
            Log::error('WhatsApp API Error: ' . $response->body(), []);
            return false;
        }

        return true;

    } catch (\Exception $e) {
        Log::error("WhatsApp API Error: " . $e->getMessage(), []);
        return ['error' => $e->getMessage()];
    }
}


}