@extends('layouts.layoutapp')

@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <form action="{{ route('branch-update', $branch->id) }}" method="POST" enctype="multipart/form-data">
                        <div class="card-header pb-0">
                            <div class="d-flex flex-row justify-content-between">
                                <div>
                                    <h5 class="mb-0">Edit Branch</h5>
                                </div>
                            </div>
                        </div>

                        <div class="card-body">
                            @csrf
                            <input type="hidden" name="branch_id" value="{{$branch->id}}">
                            <div class="row">
                                <!-- First Column: Company, Prefix, Address, Send Invoice -->
                                <div class="col-lg-4">
                                    <div class="col-lg-12 mb-3">
                                        <label for="company" class="form-label">Company:</label>
                                        <select name="company" id="company" class="form-select">
                                            <option value="">Select Company</option>
                                            @foreach($companies as $company)
                                                <option value="{{ $company->id }}" {{ $branch->company_id == $company->id ? 'selected' : '' }}>
                                                    {{ $company->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('company')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="col-lg-12 mb-3">
                                        <label for="prefix" class="form-label">Prefix:</label>
                                        <input type="text" name="prefix" class="form-control"
                                            value="{{ old('prefix', $branch->prefix) }}" required>
                                        @error('prefix')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for="email" class="form-label">Email:</label>
                                        <input type="email" name="email" class="form-control"
                                            value="{{ old('email', $branch->email) }}">
                                        @error('email')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="col-lg-12 mb-3">
                                        <label for="loyalty_amount" class="form-label">Loyalty Amount</label>
                                        <input type="text" name="loyalty_amount" id="loyalty_amount" class="form-control"
                                            value=" {{ old('loyalty_amount', $branch->loyalty_amount)}}">
                                        @error('loyalty_amount')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for="whatsapp_templete" class="form-label">WhatsApp Template </label>
                                        <input type="text" name="whatsapp_template" class="form-control"
                                            value="{{ old('whatsapp_template', $branch->whatsapp_template) }}">
                                        @error('whatsapp_template')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <!-- Second Column: Branch Name, Contact Number, Default User, Logo -->
                                <div class="col-lg-4">
                                    <div class="col-lg-12 mb-3">
                                        <label for="name" class="form-label">Branch Name:</label>
                                        <input type="text" name="name" class="form-control"
                                            value="{{ old('name', $branch->name) }}" required>
                                        @error('name')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for="non_gst_prefix" class="form-label">Non-GST Prefix:</label>
                                        <input type="text" name="non_gst_prefix" id="non_gst_prefix" class="form-control"
                                            value="{{ old('non_gst_prefix', $branch->non_gst_prefix ?? '') }}" required>
                                        @error('non_gst_prefix')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="col-lg-12 mb-3">
                                        <label for="address" class="form-label">Address:</label>
                                        <input type="text" name="address" class="form-control"
                                            value="{{ old('address', $branch->address) }}">
                                        @error('address')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="col-lg-12 mb-3">
                                        <label for="point_redemption" class="form-label">Loyalty Point Value</label>
                                        <input type="number" name="point_redemption" id="point_redemption"
                                            class="form-control"
                                            value="{{ old('point_redemption', $branch->point_redemption)}}">
                                        @error('point_redemption')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                </div>

                                <!-- Third Column: GST No, Email, Paper Size -->
                                <div class="col-lg-4">
                                    <div class="col-lg-12 mb-3">
                                        <label for="gst_no" class="form-label">GST No:</label>
                                        <input type="text" name="gst_no" class="form-control"
                                            value="{{ old('gst_no', $branch->gst_no) }}" required>
                                        @error('gst_no')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for="contact_number" class="form-label">Contact Number:</label>
                                        <input type="text" name="contact_number" class="form-control"
                                            value="{{ old('contact_number', $branch->phone) }}">
                                        @error('contact_number')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for="user_id" class="form-label">Default User:</label>
                                        <select name="user_id" id="user_id" class="form-select">
                                            <option value="">Select User</option>
                                            @foreach($users as $user)
                                                <option value="{{ $user->id }}" {{ $user_id == $user->id ? 'selected' : '' }}>
                                                    {{ $user->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('user_id')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="col-lg-12 mb-3">
                                        <label for="paper_size" class="form-label">Standard Paper:</label>
                                        <select name="paper_size" id="paper_size" class="form-select">
                                            <option value="">Select Standard</option>
                                            @foreach($paperSize as $size)
                                                <option value="{{ $size->id }}" {{ $branch->paper_size == $size->id ? 'selected' : '' }}>{{ $size->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('paper_size')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                </div>
                            </div>
                            <div class="col-lg-12 mb-3 table-responsive d-flex justify-content-center">
                                <table class="table table-bordered text-xs w-auto">
                                    <thead>
                                        <tr>
                                            <th>Send Invoice</th>
                                            <th>Loyalty Point</th>
                                            <th>Note</th>
                                            <th>Term</th>
                                            <th>Description</th>
                                            <th>Tax</th>
                                            <th>Signature</th>
                                            <th>Available Qty Validate</th>
                                            <th>Native Name</th>
                                            <th>Is Header</th>
                                            <th>Non Gst</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center">
                                                <input type="checkbox" name="send_invoice" id="send_invoice"
                                                    style="width: 18px; height: 18px;" value="A" {{ old('send_invoice', $branch->whatsapp_config) == 'A' ? 'checked' : '' }}>
                                                @error('send_invoice')<span
                                                class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                            <td class="text-center">
                                                <input type="checkbox" name="loyalty_point" id="loyalty_point"
                                                    style="width: 18px; height: 18px;" value="A" {{ old('loyalty_point', $branch->loyalty_config) == 'A' ? 'checked' : '' }}>
                                                @error('loyalty_point')<span
                                                class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                            <td class="text-center">
                                                <input type="checkbox" name="note" id="note"
                                                    style="width: 18px; height: 18px;" value="1" {{ old('note', $branch->note_flag) == 'A' ? 'checked' : '' }}>
                                                @error('note')<span class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                            <td class="text-center">
                                                <input type="checkbox" name="term" id="term"
                                                    style="width: 18px; height: 18px;" value="1" {{ old('term', $branch->terms_flag) == 'A' ? 'checked' : '' }}>
                                                @error('term')<span class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                            <td class="text-center">
                                                <input type="checkbox" name="description" id="description"
                                                    style="width: 18px; height: 18px;" value="1" {{ old('description', $branch->inv_desc_flag) == 'A' ? 'checked' : '' }}>
                                                @error('description')<span
                                                class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                            <td class="text-center">
                                                <input type="checkbox" name="price_tax" id="price_tax"
                                                    style="width: 18px; height: 18px;" value="1" {{ old('price_tax', $branch->price_tax_flag) == 'A' ? 'checked' : '' }}>
                                                @error('price_tax')<span class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                            <td class="text-center">
                                                <input type="checkbox" name="signature" id="signature"
                                                    style="width: 18px; height: 18px;" value="1" {{ old('signature', $branch->signature_flag) == 'A' ? 'checked' : '' }}>
                                                @error('signature')<span class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                            <td class="text-center">
                                                <input type="checkbox" name="avl_qty" id="avl_qty"
                                                    style="width: 18px; height: 18px;" value="1" {{ old('avl_qty', $branch->avl_qty_flag) == 'A' ? 'checked' : '' }}>
                                                @error('avl_qty')<span class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                            <td style="padding: 10px; text-align: center;">
                                                <input type="checkbox" name="native_name" id="native_name"
                                                    style="width: 18px; height: 18px;" value="1" {{ old('avl_qty', $branch->native_name_flag) == 'A' ? 'checked' : '' }}>
                                                @error('avl_qty')<span class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                            <td style="padding: 10px; text-align: center;">
                                                <input type="checkbox" name="is_header" id="is_header"
                                                    style="width: 18px; height: 18px;" value="1" {{ old('is_header', $branch->is_header) == 'A' ? 'checked' : '' }}>
                                                @error('is_header')<span class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                            <td style="padding: 10px; text-align: center;">
                                                <input type="checkbox" name="non_gst" id="non_gst"
                                                    style="width: 18px; height: 18px;" value="1" {{ old('non_gst', $branch->non_gst) == 'A' ? 'checked' : '' }}>
                                                @error('non_gst')<span class="text-danger">{{ $message }}</span>@enderror
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <div class="col-lg-12 mb-3">
                                <label for="declaration" class="form-label">Terms & Condition</label>
                                <textarea name="declaration" class="form-control"
                                    rows="2"> {{ old('declaration', $branch->declaration ?? '') }}</textarea>
                                @error('declaration')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="col-lg-12 mb-3">
                                <label for="logo" class="form-label">Logo:</label>
                                <div class="d-flex align-items-center mt-2" style="height: 50px;width: 430px;">
                                    <div class="avatar-upload me-5">
                                        <div class="avatar-preview">
                                            @if ($branch->logo)
                                                <img id="logoPreview" src="{{ getFileUrl($branch->logo) }}" alt="Branch Logo"
                                                    class="img-fluid mt-4" style="height: 80px; width: auto; max-width:250px;">
                                            @else
                                                <img id="logoPreview" src="{{ asset('assets/img/logos/Product.png') }}"
                                                    alt="Default Image" class="img-fluid mt-4"
                                                    style="height: 80px; width: auto; max-width:250px;">
                                            @endif
                                        </div>
                                    </div>
                                    <div class="avatar-edit">
                                        <input type="file" id="logo" class="form-control file-upload-input mb-3"
                                            accept="image/*" name="logo" onchange="previewLogo(this)">
                                        <small class="text-muted d-block mt-1">Recommended size:
                                            <strong>781x320</strong> pixels</small>
                                    </div>
                                </div>
                                @error('logo')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary ms-0">Update Branch</button>
                                <a href="{{ route('branch-index') }}" class="btn btn-secondary">Cancel</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        function previewLogo(input) {
            const preview = document.getElementById('logoPreview');
            const file = input.files[0];
            const reader = new FileReader();

            reader.onloadend = function () {
                preview.src = reader.result;
            }

            if (file) {
                reader.readAsDataURL(file);
            } else {
                preview.src = "{{ $branch->logo ? getFileUrl($branch->logo) : asset('assets/img/logos/Product.png') }}";
            }
        }
    </script>
@endpush