<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>New Quote Notification</title>
    <style>
        body {
            font-family: 'Helvetica Neue', Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .logo {
            max-width: 150px;
            margin-bottom: 20px;
        }
        .content {
            background-color: #f9f9f9;
            padding: 25px;
            border-radius: 5px;
        }
        .button {
            display: inline-block;
            padding: 10px 20px;
            background-color: #3490dc;
            color: white !important;
            text-decoration: none;
            border-radius: 4px;
            margin-top: 15px;
        }
        .footer {
            margin-top: 30px;
            font-size: 12px;
            color: #777;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="header">     
        <h1>{{ config('app.name') }}</h1>
    </div>

    <div class="content">
        <h2>New Order Created</h2>

        <p>Hello Admin,</p>

        <p>A new order has been generated with the following details:</p>

        <ul>
            <li><strong>Order ID:</strong> #{{ $order->order_id }}</li>
            <li><strong>Client:</strong> {{ $order->client->user->name ?? 'N/A' }}</li>
            <li><strong>Client Number:</strong> {{ $order->client->user->phone ?? 'N/A' }}</li>
            <li><strong>Date:</strong> {{ $order->created_at->format('F j, Y') }}</li>
        </ul>

        <p>The PDF version of the order is attached to this email for your reference.</p>
       
    </div>

    <div class="footer">
        <p>This is an automated notification. Please do not reply to this email.</p>
        <p>&copy; {{ date('Y') }} {{ $settings->company->name ?? config('app.name') }}. All rights reserved.</p>
    </div>
</body>
</html>
