@extends('layouts.layoutapp')

@section('content')
<div class="main-content">
    <div class="row">
        <div class="col-12">
            <div class="card mb-4 mx-4">
                <div class="card-header pb-0">
                    <div class="d-flex flex-row justify-content-between">
                        <div>
                            <h5 class="mb-0">Edit Rights for {{ $staff->name }}</h5>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <form action="{{ route('rights-update') }}" method="POST">
                        @csrf
<input type="hidden" name="id" value="{{$staff->id}}">                        
                        <div class="row">
                            <label for="isDefault" class="form-label">Modules</label>
                            @forelse ($modules as $index => $module)
                                <div class="col-lg-3">
                                    <div class="form-check form-check-inline">
                                        <input type="checkbox" id="{{ $index }}" name="modules[{{ $index }}]" 
                                            class="form-check-input" value="1" 
                                            {{ isset($assignedModules[$index]) ? 'checked' : '' }}>
                                        <label for="{{ $index }}" class="form-check-label">{{ ucfirst($index) }}</label>
                                    </div>
                                </div>
                            @empty
                                <div class="col-lg-12">No Modules Found.</div>
                            @endforelse
                        </div>

                        <div class="mt-4 text-end">
                            <button type="submit" class="btn btn-primary">Save Rights</button>
                            <a href="{{ route('rights-index') }}" class="btn btn-secondary">Cancel</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection