@extends('layouts.layoutapp')
@section('content')
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h5 class="mb-0">Add New Supplier</h5>
                        </div>
                    </div>

                    <div class="card-body">
                        <form action="{{ route('supplier-store') }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-lg-4 mb-4">
                                    <label for="name" class="form-label">Name:</label>
                                    <input type="text" id="name" name="name" class="form-control" 
                                        value="{{ old('name') }}" 
                                        placeholder="Enter supplier name" required>
                                    @error('name') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="phone_Number" class="form-label">Phone Number</label>
                                    <input type="number" id="phone_Number" name="phone_Number" class="form-control" 
                                        value="{{ old('phone_Number') }}"
                                        placeholder="Enter phone number" required>
                                    @error('phone_Number') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="email" class="form-label">Email</label>
                                    <input type="email" id="email" name="email" class="form-control"
                                        value="{{ old('email') }}"
                                        placeholder="Enter email address">
                                    @error('email') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="address" class="form-label">Address</label>
                                    <input type="text" id="address" name="address" class="form-control"
                                        value="{{ old('address') }}"
                                        placeholder="Enter supplier address">
                                    @error('address') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-4 mb-4">
                                    <label for="isActive" class="form-label">Is Active?</label>
                                    <div class="d-flex">
                                        <div class="form-check form-check-inline">
                                            <input type="radio" id="isActiveYes" class="form-check-input" name="isActive"
                                                value="1" {{ old('isActive') == '1' ? 'checked' : '' }} required>
                                            <label for="isActiveYes" class="form-check-label">Yes</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input type="radio" id="isActiveNo" class="form-check-input" name="isActive"
                                                value="0" {{ old('isActive') == '0' ? 'checked' : '' }} required>
                                            <label for="isActiveNo" class="form-check-label">No</label>
                                        </div>
                                    </div>
                                    @error('isActive') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">Save Supplier</button>
                                <a href="{{ route('supplier-index') }}" class="btn btn-secondary">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection