<?php

namespace App\Http\Controllers;
use App\Models\CategoryModel;
use App\Models\ProductTypeModel;
use App\Models\SupplierModel;
use App\Models\UomModel;
use Illuminate\Support\Facades\DB;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Cell\DataValidation;


use Illuminate\Http\Request;

class TemplateController extends Controller
{
    public function productTemplate()
    {
        $templatePath = storage_path('app/public/template/ProductTemplate.xlsx');
        $spreadsheet = IOFactory::load($templatePath);
        $sheet = $spreadsheet->getActiveSheet();

        $category = CategoryModel::where('branch_id', session('branch_id'))->where('active_flag', 'A')->pluck('name')->toArray();
        $supplier = SupplierModel::where('branch_id', session('branch_id'))->where('active_status', 1)->where('oprntl_flag', 'A')->pluck('supplier_name')->toArray();
        $productType = ProductTypeModel::where('oprntl_flag', 'A')->pluck('name')->toArray();

        $this->setDropdown($sheet, 'H', $category);
        $this->setDropdown($sheet, 'I', $supplier);
        $this->setDropdown($sheet, 'M', $productType);

        $writer = new Xlsx($spreadsheet);
        $filePath = storage_path('app/public/import-template/ProductTemplate_with_dropdown.xlsx');
        $writer->save($filePath);
        return response()->download($filePath);
    }


    public function categoriesTemplate()
    {
        $templatePath = storage_path('app/public/template/CategoriesTemplate.xlsx');
        $spreadsheet = IOFactory::load($templatePath);
        $sheet = $spreadsheet->getActiveSheet();

        $uom = UomModel::pluck('name')->toArray();

        $this->setDropdown($sheet, 'B', $uom);

        $writer = new Xlsx($spreadsheet);
        $filePath = storage_path('app/public/import-template/CategoriesTemplate_with_dropdown.xlsx');
        $writer->save($filePath);
        return response()->download($filePath);
    }
    public function supplierTemplate()
    {
        $templatePath = storage_path('app/public/template/SupplierTemplate.xlsx');

        return response()->download($templatePath);
    }

    public function clientTemplate()
    {
        $templatePath = storage_path('app/public/template/ClientTemplate.xlsx');
        $spreadsheet = IOFactory::load($templatePath);
        $sheet = $spreadsheet->getActiveSheet();

        $referenceSheet = $spreadsheet->createSheet();

        $countries = DB::table('countries')->where('oprntl_flag', 'A')->get();
        $country_names = $countries->pluck('name')->toArray();

        $states = DB::table('states')->where('oprntl_flag', 'A')->get();
        $state_names = $states->pluck('name')->toArray();

        $cities = DB::table('cities')->where('oprntl_flag', 'A')->get();
        $city_names = $cities->pluck('name')->toArray();

        $this->setDropdown($sheet, 'I', $country_names);
        $this->setDropdown($sheet, 'J', $state_names);
        // $this->setDropdown($sheet, 'K', $city_names);

        $writer = new Xlsx($spreadsheet);
        $filePath = storage_path('app/public/import-template/ClientTemplate_with_dropdown.xlsx');
        $writer->save($filePath);

        return response()->download($filePath);
    }

    public function taxTemplate()
    {
        $templatePath = storage_path('app/public/template/TaxTemplate.xlsx');
        $spreadsheet = IOFactory::load($templatePath);
        $sheet = $spreadsheet->getActiveSheet();

        $check = ['TRUE', 'FALSE'];

        $this->setDropdown($sheet, 'C', $check);
        $this->setDropdown($sheet, 'D', $check);

        $writer = new Xlsx($spreadsheet);
        $filePath = storage_path('app/public/import-template/TaxTemplate_with_dropdown.xlsx');
        $writer->save($filePath);
        return response()->download($filePath);
    }

    protected function setDropdown($sheet, $column, $options)
    {
        $validation = $sheet->getDataValidation($column . '2');

        $validation->setType(DataValidation::TYPE_LIST)
            ->setAllowBlank(false)
            ->setShowDropDown(true)
            ->setFormula1('"' . implode(',', $options) . '"');

        $validation->setErrorStyle(DataValidation::STYLE_STOP);
        $validation->setErrorTitle('Invalid entry');
        $validation->setError('Please select a value from the list.');

        $sheet->setDataValidation($column . '2:' . $column . '1000', $validation);
    }


}
