<x-layouts.base>
    {{-- If the user is authenticated --}}
    @auth
        {{-- If the user is on the sign-up page or static sign-up --}}
        @if (in_array(Route::currentRouteName(), ['static-sign-up', 'sign-up']))
            @include('layouts.navbars.guest.sign-up')
            @yield('content') {{-- This will include the page's content section --}}
            @include('layouts.footers.guest.with-socials')

            {{-- If the user is on the login page or static sign-in --}}
        @elseif (in_array(Route::currentRouteName(), ['sign-in', 'login']))
            @include('layouts.navbars.guest.login')
            @yield('content')
            @include('layouts.footers.guest.description')

            {{-- If the user is on the setup page --}}
        @elseif (Route::currentRouteName() == 'setup')
            @include('layouts.navbars.guest.login')
            @yield('content')
            @include('layouts.footers.guest.description')

            {{-- If the user is on the profile page --}}
        @elseif (in_array(Route::currentRouteName(), ['profile', 'my-profile']))
            @include('layouts.navbars.auth.sidebar')
            <div class="main-content position-relative bg-gray-100">
                @include('layouts.navbars.auth.nav-profile')
                <div>
                    @yield('content')
                    @include('layouts.footers.auth.footer')
                </div>
            </div>
            @include('components.plugins.fixed-plugin')

            {{-- For all other authenticated user pages --}}
        @else
            @include('layouts.navbars.auth.sidebar')
            @include('layouts.navbars.auth.nav')
            @yield('content') {{-- This will include the page's content section --}}
            <main>
                <div class="container-fluid">
                    <div class="row">
                        @include('layouts.footers.auth.footer')
                    </div>
                </div>
            </main>
        @endif

    @endauth

    {{-- If the user is not authenticated (guest) --}}
    @guest
        {{-- If the user is on the login page --}}
        @if (Route::currentRouteName() == 'login')
            @include('layouts.navbars.guest.login')
            @yield('content')
            <div class="mt-5">
                @include('layouts.footers.guest.with-socials')
            </div>

            {{-- If the user is on the sign-up page --}}
        @elseif (Route::currentRouteName() == 'sign-up')
            <div>
                @include('layouts.navbars.guest.sign-up')
                @yield('content')
                @include('layouts.footers.guest.with-socials')
            </div>
        @endif
    @endguest
</x-layouts.base>