@extends('layouts.layoutapp')

@section('content')

<div class="main-content">
    <div class="row">
        <div class="col-12">
            <div class="card mb-4 mx-4">
        <div class="card-body">
            <div class="d-flex justify-content-end align-items-center mb-3 px-3">
                <form method="GET" action="{{ route('invoice-emi-Report') }}" class="d-flex align-items-center">
                    <div class="form-group me-3">
                        <input type="date" class="form-control @error('start_date') is-invalid @enderror"
                            id="start_date" name="start_date"
                            value="{{ old('start_date', request()->get('start_date')) }}">

                        <!-- Display error message for start_date -->
                        @error('start_date')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group me-3">
                        <input type="date" class="form-control @error('end_date') is-invalid @enderror" id="end_date"
                            name="end_date" value="{{ old('end_date', request()->get('end_date')) }}">

                        <!-- Display error message for end_date -->
                        @error('end_date')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group me-3">

                        <select name="status" id="status" class="form-control">
                            <option value="">Filters</option>
                            <option value=" " {{ request()->get('status') == 'all' ? 'selected' : '' }}>All</option>
                            <option value="Y" {{ request()->get('status') == 'gst' ? 'selected' : '' }}>GST</option>
                            <option value="N" {{ request()->get('status') == 'non_gst' ? 'selected' : '' }}>Non-GST
                            </option>

                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary">Filter</button>
                </form>
            </div>

            <div class="table-responsive">
                <table class="table align-items-center mb-0 table-hover text-sm" id="myTable">
                    <thead>
                        <tr>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Invoice ID
                            </th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Client Name
                            </th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Branch Name
                            </th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Invoice Date
                            </th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Due Date
                            </th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">GST</th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Tax</th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Discount
                                type</th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Discount
                            </th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Final Amount
                            </th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Down Payment
                            </th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">EMI
                                Percentage</th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">EMI Amount
                            </th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">EMI Base
                                Amount</th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">EMI Discount
                            </th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Penalty
                                Amount</th>
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Paid Amount
                            </th>

                            {{-- <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Status
                            </th> --}}
                            <th class="text-uppercase text-secondary  font-weight-bolder opacity-7">Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($results as $data)                        
                                                <tr>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0">{{ $data->invoice_id ?? '' }}</p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0">
                                                            {{ $data->client ? $data->client->user->name : '' }}
                                                        </p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0">{{ $data->branch->name ?? '' }}</p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0">
                                                            {{ $data->invoice_date ? \Carbon\Carbon::parse($data->invoice_date)->format('d-m-Y') : '' }}
                                                        </p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0">
                                                            {{ $data->due_date ? \Carbon\Carbon::parse($data->due_date)->format('d-m-Y') : '' }}
                                                        </p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0">{{ $data->gst == 'Y' ? 'Yes' : 'No' }}</p>
                                                    </td>
                                                    <td class="ps-4">
                                                        @php
                                                            $taxDetails = [];
                                                            foreach ($data->invoiceItems as $item) {
                                                                foreach ($item->invoiceItemTaxes as $taxes) {
                                                                    $taxName = $taxes->taxes->name;
                                                                    if (!isset($taxDetails[$taxName])) {
                                                                        $taxDetails[$taxName] = 0;
                                                                    }
                                                                    $taxDetails[$taxName] = $taxes->tax;
                                                                }
                                                            }
                                                        @endphp
                                                    
                                                        <ul style="list-style-type: none; padding-left: 0;">
                                                            @if(count($taxDetails))
                                                                @foreach($taxDetails as $name => $value)
                                                                    <li class="text-xs font-weight-bold mb-0">
                                                                        {{ $name }}: {{ number_format($value, 2) }}
                                                                    </li>
                                                                @endforeach
                                                            @else
                                                                <li class="text-xs font-weight-bold mb-0">No tax available</li>
                                                            @endif
                                                        </ul>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0">
                                                            {{ $data->discount_type === null ? 'Not Set' : ($data->discount_type == 1 ? 'Fixed' : 'Percentage') }}
                                                        </p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0">{{ $data->discount ?? '' }}</p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0">{{ $data->final_amount ?? '' }}</p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0">{{ $data->invoice_emi->down_payment ?? '' }}
                                                        </p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0">{{ $data->invoice_emi->intersest_rate ?? '' }}
                                                        </p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0">{{ $data->invoice_emi->emi_amount ?? '' }}</p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <p class="text-xs font-weight-bold mb-0">{{ $data->invoice_emi->actual_amount ?? '' }}
                                                        </p>
                                                    </td>
                                                    <td class="ps-4">
                                                        @php
                                                            if ($data->invoice_emi) {
                                                                $discount = 0;
                                                                foreach ($data->invoice_emi->invoice_emi_dtls as $emiDetail) {
                                                                    $discount += $emiDetail->discount_amount;
                                                                }
                                                            }
                                                        @endphp
                                                        <p class="text-xs font-weight-bold mb-0">{{ $discount ?? '' }}</p>
                                                    </td>
                                                    <td class="ps-4">
                                                        @php                                                       
                                                                                                                                                                                                                                                                if ($data->invoice_emi) {
                                                                $penalty = 0;
                                                                foreach ($data->invoice_emi->invoice_emi_dtls as $emiDetail) {
                                                                    $penalty += is_numeric($emiDetail->penalty) ? (int) $emiDetail->penalty : 0;
                                                                }
                                                            }
                                                        @endphp
                                                        <p class="text-xs font-weight-bold mb-0">{{ $penalty ?? '' }}</p>
                                                    </td>
                                                    <td class="ps-4">
                                                        @php
                                                            if ($data->invoice_emi) {
                                                                $finalAmount = 0;
                                                                foreach ($data->invoice_emi->invoice_emi_dtls as $emiDetail) {
                                                                    $finalAmount += $emiDetail->total_amount;
                                                                }
                                                            }
                                                        @endphp
                                                        <p class="text-xs font-weight-bold mb-0">{{ $finalAmount ?? '' }}</p>
                                                    </td>
                                                    <td class="ps-4">
                                                        <a href="#" data-bs-toggle="modal" data-bs-target="#emiModal" data-id="{{$data->id}}">
                                                            <i class="fa-solid fa-eye"></i>
                                                        </a>
                                                    </td>
                                                </tr>

                        @endforeach

                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
</div>
</div>

<div class="modal fade" id="emiModal" tabindex="-1" aria-labelledby="emiModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="emiModalLabel"></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body table-responsive">
                <table class="table table-bordered text-center text-sm">
                    <thead>
                        <tr>
                            <th>Emi Date</th>
                            <th>EMI Amount</th>
                            <th>Paid Date</th>
                            {{-- <th>Paid Amount</th> --}}
                            <th>Due Days</th>
                            <th>Penalty Amount</th>
                            <th>Discount Amount</th>
                            <th>Paid Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                    <tfoot>
                    </tfoot>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
    document.getElementById('emiModal').addEventListener('show.bs.modal', function (event) {
        var button = event.relatedTarget;
        var id = button.getAttribute('data-id');

        fetch('/get-invoice-details/' + id)
            .then(response => response.json())
            .then(data => {
                document.getElementById('emiModalLabel').textContent = 'Invoice EMI Report: ' + data.invoice_number;

                var tbody = document.querySelector('#emiModal .modal-body table tbody');
                tbody.innerHTML = '';
                let totalPaidAmount = 0;

                data.emi_details.forEach(function (product) {
                    var row = document.createElement('tr');
                    var emiDate = product.emi_date ? new Date(product.emi_date) : null;
                    var paidDate = product.paid_date ? new Date(product.paid_date) : null;
                    var formattedEmiDate = emiDate ?
                        (emiDate.getDate() + '/' + String(emiDate.getMonth() + 1).padStart(2, '0') + '/' + emiDate.getFullYear())
                        : '0';

                    var formattedPaidDate = paidDate ?
                        (paidDate.getDate() + '/' + String(paidDate.getMonth() + 1).padStart(2, '0') + '/' + paidDate.getFullYear())
                        : '0';

                    var totalAmount = product.total_amount ? parseFloat(product.total_amount.replace(/[^\d.-]/g, '')) : 0;
                    totalPaidAmount += totalAmount;
                    row.innerHTML = '<td>' + formattedEmiDate + '</td>' +
                        '<td>₹ ' + (product.emi_amount || 0) + '</td>' +
                        '<td>' + formattedPaidDate + '</td>' +
                        '<td>' + (product.due_days || 0) + '</td>' +
                        '<td>₹ ' + (product.penalty || 0) + '</td>' +
                        '<td>₹ ' + (product.discount_amount || 0) + '</td>' +
                        '<td>₹ ' + (product.total_amount || 0) + '</td>';
                    tbody.appendChild(row);
                });

                var modalFooter = document.querySelector('#emiModal .modal-body table tfoot');
                modalFooter.innerHTML = '';

                var totalPaidRow = document.createElement('tr');
                totalPaidRow.innerHTML = `
                <td colspan="6" class="text-end"><strong>Total Paid Amount: </strong></td>
                <td><strong>₹ ${totalPaidAmount}</strong></td>
            `;
                modalFooter.appendChild(totalPaidRow);
            })
            .catch(error => {
                console.error('Error:', error);
            });
    });

</script>

@endsection