

<?php $__env->startSection('content'); ?>

    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">Add New Invoice</h5>
                            </div>
                            <div>
                                <p class="badge bg-secondary due_amount">Due Amount:</p>
                            </div>
                        </div>
                    </div>

                    <div class="card-body">
                        <form action="<?php echo e(route('invoice-store')); ?>" method="POST" id="invoiceForm">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-lg-3 mb-3">
                                    <label for="client_name" class="form-label">Client Name:</label>
                                    <input type="text" name="client_name" id="client_name" class="form-control"
                                        value="<?php echo e(old('client_name')); ?>">
                                    <span class="text-danger d-block mt-1" id="client_name_error"></span>
                                    <?php $__errorArgs = ['client_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-3 mb-3">
                                    <label for="client_num" class="form-label">Client Number:</label>
                                    <select name="client_num" id="client_num_select" class="select2 form-select" multiple>
                                        <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($client->user->phone); ?>" data-clientID=<?php echo e($client->id); ?> <?php echo e(in_array($client->user->phone, (array) old('client_num', [])) ? 'selected' : ''); ?>><?php echo e($client->user->phone); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div id="client_num_error" class="text-danger small" style="display: none;"></div>
                                    <?php $__errorArgs = ['client_num'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-3 mb-3">
                                    <label for="invoice_id" class="form-label">Invoice number:</label>
                                    <input type="text" id="invoice_id" class="form-control" value="" readonly>
                                </div>
                                <div class="col-lg-3 mb-3">
                                    <label for="invoice_date" class="form-label">Invoice Date:</label>
                                    <input type="date" id="invoice_date" class="form-control" name="invoice_date"
                                        value="<?php echo e(old('invoice_date', \Carbon\Carbon::now()->format('Y-m-d'))); ?>" required>
                                    <?php $__errorArgs = ['invoice_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-lg-3 mb-3">
                                    <label for="due_date" class="form-label">Due Date:</label>
                                    <input type="date" id="due_date" class="form-control" name="due_date"
                                        value="<?php echo e(old('due_date', \Carbon\Carbon::now()->format('Y-m-d'))); ?>" required>
                                    <?php $__errorArgs = ['due_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <?php if($branch->non_gst == 'A'): ?>
                                    <div class="col-lg-3 mb-3">
                                        <label for="gst" class="form-label">GST/Non-GST:</label>
                                        <select name="gst" id="gst" class="form-select" onchange="toggleTaxes()">
                                            <option value="">Select</option>
                                            <option value="Y" <?php echo e(old('gst') == 'Y' ? 'selected' : ''); ?>>GST</option>
                                            <option value="N" <?php echo e(old('gst') == 'N' ? 'selected' : ''); ?>selected>Non-GST</option>
                                        </select>
                                        <?php $__errorArgs = ['gst'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                <?php else: ?>
                                    <div class="col-lg-3 mb-3">
                                        <label for="gst" class="form-label">GST/Non-GST:</label>
                                        <select name="gst" id="gst" class="form-select" onchange="toggleTaxes()">
                                            <option value="">Select</option>
                                            <option value="Y" <?php echo e(old('gst') == 'Y' ? 'selected' : ''); ?> selected>GST</option>
                                            <option value="N" <?php echo e(old('gst') == 'N' ? 'selected' : ''); ?>>Non-GST</option>
                                        </select>
                                        <?php $__errorArgs = ['gst'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <hr>
                            <div>
                                <h5>Product Details:</h5>
                                <div class="row align-items-center">
                                    <div class="col-lg-4 d-flex align-items-center mb-3">
                                        <i class="fa-solid fa-qrcode"
                                            style="width: 30px; height: 30px; margin-right: 10px;"></i>
                                        <input class="form-control" type="text" id="product-code-input"
                                            onkeydown="preventFormSubmit(event)">
                                    </div>
                                    <div class="col-lg-4">
                                        <button type="button" onclick="addRow(event)" class="btn btn-primary addRow">
                                            <i class="fas fa-plus"></i> Add Row
                                        </button>
                                    </div>
                                </div>

                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped text-sm" id="productsTable">
                                        <thead class="thead-dark">
                                            <tr>
                                                
                                                <th>Product</th>
                                                <th>Avl. Qty</th>
                                                <th>Qty</th>
                                                <th>Unit Price</th>
                                                <th>Tax</th>
                                                <th>Amount</th>
                                                <th class="text-center align-middle w-0"></th>
                                            </tr>
                                        </thead>
                                        <tbody id="productRows">
                                            <!-- Dynamic rows will be added here -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row mt-5">
                                <div class="col-lg-6 mb-3 d-flex">
                                    <div class="col-lg-6">
                                        <label for="discount_type" class="form-label">Discount type:</label>
                                        <select name="discount_type" id="discount_type" class="form-select"
                                            onchange="calculateTotal()">
                                            <option value="">Select discount type</option>
                                            <?php $__currentLoopData = $discount_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($type->id); ?>" <?php echo e(old('discount_type') == $type->id ? 'selected' : ''); ?>>
                                                    <?php echo e($type->type); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['discount_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="col-lg-6">
                                        <label for="discount" class="form-label">Discount:</label>
                                        <input type="number" id="discount" name="discount" class="form-control"
                                            value="<?php echo e(old('discount')); ?>" onchange="calculateTotal()" <?php echo e(empty(old('discount_type')) ? 'readonly' : ''); ?>>
                                        <?php $__errorArgs = ['discount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-lg-5 mb-3">
                                    <div class="card shadow-lg">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between pl-5">
                                                <span>Sub Total:</span>
                                                <span id="subTotalDisplay">0 ₹</span>
                                            </div>
                                            <div class="d-flex justify-content-between pl-5">
                                                <span>Discount:</span>
                                                <span id="discountDisplay">0 ₹</span>
                                            </div>
                                            <div class="d-flex justify-content-between pl-5">
                                                <span>Tax:</span>
                                                <span id="taxDisplay">0 ₹</span>
                                            </div>
                                            <div class="d-flex justify-content-between pl-5">
                                                <span>Total:</span>
                                                <span id="totalDisplay">0 ₹</span>
                                            </div>
                                            <input type="hidden" id="sub_total" name="sub_total" value="0">
                                            <input type="hidden" id="discount_amt" name="discount_amt" value="0">
                                            <input type="hidden" id="tax" name="tax" value="0">
                                            <input type="hidden" id="total_amt" name="total_amt" value="0">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <hr>
                            <div>
                                <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap">
                                    <div class="d-flex align-items-center gap-3 flex-wrap">
                                        <!-- Label -->
                                        <h5 class="mb-0">Payment Details:</h5>

                                        <!-- Tendered Amount Input -->
                                        <input type="number" step="0.01" name="tendered_amount" id="tendered_amount"
                                            class="form-control w-auto" style="min-width: 200px;"
                                            value="<?php echo e(old('tendered_amount')); ?>" placeholder="Enter tendered amount">
                                        <?php $__errorArgs = ['tendered_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <!-- Extra Amount Badge (Right Side) -->
                                    <span class="badge bg-primary extra_amount">Extra Amount: ₹ 0.00</span>
                                </div>

                                <div class="row g-3">
                                    <!-- UPI -->
                                    <div class="col-md-4">
                                        <label for="upi" class="form-label">UPI:</label>
                                        <input type="text" name="upi" id="upi" class="form-control"
                                            value="<?php echo e(old('upi')); ?>">
                                        <?php $__errorArgs = ['upi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>


                                    <!-- Cash -->
                                    <div class="col-md-4">
                                        <label for="cash" class="form-label">Cash:</label>
                                        <input type="text" name="cash" id="cash" class="form-control"
                                            value="<?php echo e(old('cash')); ?>">
                                        <?php $__errorArgs = ['cash'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <!-- Online -->
                                    <div class="col-md-4">
                                        <label for="online" class="form-label">Online:</label>
                                        <input type="text" name="online" id="online" class="form-control"
                                            value="<?php echo e(old('online')); ?>">
                                        <?php $__errorArgs = ['online'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <!-- Payment total errors -->
                                    <?php if($errors->has('payment_total')): ?>
                                        <div class="col-12 text-danger">
                                            <?php echo e($errors->first('payment_total')); ?>

                                        </div>
                                    <?php endif; ?>
                                </div>

                                <?php if($branch->loyalty_config == 'A'): ?>
                                    <!-- Loyalty Points Section -->
                                    <div class="col-lg-12 mt-3 d-flex justify-content-between">
                                        <div class="col-md-3 mb-3 redeem_points current_point me-3" style="display: none">
                                            <label for="redeem_points" class="form-label">Redeem Points:</label>
                                            <input type="number" name="redeem_points" id="redeem_points" class="form-control"
                                                value="<?php echo e(old('redeem_points')); ?>">
                                            <?php $__errorArgs = ['redeem_points'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="card shadow-lg h-100 col-md-3 redeem_points" style="display: none">
                                            <div class="card-body d-flex flex-column justify-content-center">
                                                <div class="d-flex justify-content-between mb-2">
                                                    <span>Earned Points:</span>
                                                    <span id="earnPoints">0 <i
                                                            class="fa-solid fa-coins text-warning"></i></span>
                                                </div>
                                                <div class="d-flex justify-content-between mb-2">
                                                    <span>Redeemed Points:</span>
                                                    <span id="redeemPoints">0 <i
                                                            class="fa-solid fa-coins text-warning"></i></span>
                                                </div>
                                                <div class="d-flex justify-content-between">
                                                    <span>Available Points:</span>
                                                    <span id="availablePoints">0 <i
                                                            class="fa-solid fa-coins text-warning"></i></span>
                                                </div>
                                            </div>
                                        </div>

                                        <input type="hidden" id="earn_point" name="earn_point" value="0">
                                        <input type="hidden" id="redeem_point" name="redeem_point" value="0">
                                        <input type="hidden" id="available_point" name="available_point" value="0">
                                    </div>
                                <?php endif; ?>
                            </div>

                            <hr>
                            <div>
                                <?php
                                    $showNote = $branch->note_flag === 'A';
                                    $showTerm = $branch->terms_flag === 'A';
                                    $buttonLabel = 'Add ';
                                    if ($showNote && $showTerm) {
                                        $buttonLabel .= 'Note & Term';
                                    } elseif ($showNote) {
                                        $buttonLabel .= 'Note';
                                    } elseif ($showTerm) {
                                        $buttonLabel .= 'Terms';
                                    }
                                ?>

                                <?php if($showNote || $showTerm): ?>
                                    <button type="button" onclick="toggleNotesAndTerms('<?php echo e($buttonLabel); ?>')"
                                        class="btn btn-primary" id="notesTermsBtn">
                                        <i class="fas fa-plus"></i> <?php echo e($buttonLabel); ?>

                                    </button>
                                <?php endif; ?>

                                <div class="row mt-3" id="notesTermsSection" style="display: none;">
                                    <?php if($showNote): ?>
                                        <div class="col-lg-6">
                                            <label for="note" class="form-label">Note:</label>
                                            <textarea class="form-control" data-label='Note' name="note"
                                                id="note"><?php echo e(old('note')); ?></textarea>
                                        </div>
                                    <?php endif; ?>

                                    <?php if($showTerm): ?>
                                        <div class="col-lg-6">
                                            <label for="term" class="form-label">Term:</label>
                                            <textarea class="form-control" data-label='Term' name="term"
                                                id="term"><?php echo e(old('term')); ?></textarea>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="modal-footer d-flex justify-content-between">
                                <div>
                                    <div class="d-flex justify-content-end align-items-center">
                                        <span class="me-3 fw-bold">Total Purchased Products Qty:</span>
                                        <span id="totalQuantity" class="badge bg-primary"
                                            style="font-size: 1.1rem;">0</span>
                                    </div>
                                </div>
                                <div>
                                    <button type="submit" id="submit" class="btn btn-primary">Save</button>
                                    <a href="<?php echo e(route('invoice-index')); ?>" class="btn btn-secondary">Cancel</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        // Product data from backend
        const products = <?php echo json_encode($products, 15, 512) ?>;
        const taxes = <?php echo json_encode($all_taxes, 15, 512) ?>;
        const defaultTaxIds = <?php echo json_encode($default_taxes, 15, 512) ?>;
        const pointValue = <?php echo json_encode($point_value, 15, 512) ?>;
        const isDescription = <?php echo json_encode($branch->inv_desc_flag, 15, 512) ?>;
        const isLoyalty = <?php echo json_encode($branch->loyalty_config, 15, 512) ?>;
        const isAvl = <?php echo json_encode($branch->avl_qty_flag, 15, 512) ?>;
        const isNavite = <?php echo json_encode($branch->native_name_flag, 15, 512) ?>;


        let avlPoint = 0;
        let redeemPoints = 0;
        let total = 0;
        let rowCount = 0;
        let hasQuantityError = false;

        function preventFormSubmit(event) {
            if (event.key === 'Enter') {
                event.preventDefault();
                addProductRow();
                setTimeout(() => {
                    document.getElementById('product-code-input').focus();
                }, 1000);
            }
        }

        function addRow(event) {
            event.preventDefault();
            addProductRow();
            setTimeout(() => {
                document.getElementById('product-code-input').focus();
            }, 1000);
        }

        function addProductRow() {
            const productCode = document.getElementById('product-code-input').value;
            if (!productCode) {
                addEmptyRow();
                return;
            }

            const product = products.find(p => p.code === productCode);
            if (product) {
                const existingRow = findProductRow(product.id);

                if (existingRow) {
                    const qtyInput = existingRow.querySelector('.qty');
                    const currentQty = parseFloat(qtyInput.value) || 0;
                    qtyInput.value = currentQty + 1;
                    calculateRowAmount(existingRow.id.split('-')[1]);
                    checkQuantity(existingRow.id.split('-')[1]);
                } else {
                    addProductToTable(product);
                }

                document.getElementById('product-code-input').value = '';
            } else {
                alert('Product not found!');
            }
        }

        function findProductRow(productId) {
            const rows = document.querySelectorAll('#productRows tr');
            for (const row of rows) {
                const select = row.querySelector('.product-select');
                if (select && select.value == productId) {
                    return row;
                }
            }
            return null;
        }

        function addEmptyRow() {
            rowCount++;
            const row = `
                                                                            <tr id="row-${rowCount}">
                                                                            
                                                                            <td>
                                                                            <div class="d-flex flex-column">
                                                                                <select name="dynamicFields[${rowCount}][product]" class="form-select product-select mb-2" 
                                                                                    onchange="updateProductDetails(${rowCount})">
                                                                                    <option value="">Select Product</option>
                                                                                    ${products.map(p => {
                const name = p.branch.native_name_flag == 'A' ? (p.native_name ?? p.name) : p.name;
                return `<option value="${p.id}">${p.code} - ${name}</option>`;
            }).join('')}
                                                                                </select>
                                                                            ${isDescription === 'A' ? `
                                                                                        <input type="text" name="dynamicFields[${rowCount}][description]"
                                                                                            style="padding-left:10px !important;" class="form-control mt-1"
                                                                                            id="description-${rowCount}" placeholder="Enter a Description">
                                                                                    ` : ''}
                                                                            </div>
                                                                                </td>
                                                                                <td style="width:120px;">
                                                                                <input type="text" name="dynamicFields[${rowCount}][avl_qty]" class="form-control avl-qty" readonly />
                                                                                </td>
                                                                                <td style="width:120px;">
                                                                                <input type="text" name="dynamicFields[${rowCount}][qty]" class="form-control qty" 
                                                                                onchange="calculateRowAmount(${rowCount})" 
                                                                                oninput="checkQuantity(${rowCount})" />
                                                                                <div class="invalid-feedback quantity-error" style="display: none;">
                                                                                Quantity exceeds available stock!
                                                                                </div>
                                                                                </td>
                                                                                <td style="width:120px;">
                                                                                <input type="text" name="dynamicFields[${rowCount}][unit_price]" class="form-control unit-price"
                                                                                onchange="calculateRowAmount(${rowCount})" />
                                                                                </td>
                                                                                <td style="min-width: 150px;">
                                                                                <select name="dynamicFields[${rowCount}][tax][]" class="form-select tax-select" multiple
                                                                                style="height: 50px;"
                                                                                onchange="calculateRowAmount(${rowCount})">
                                                                                ${taxes.map(t => {
                const taxId = t.id; // No need to convert to string if IDs are numbers
                const isDefault = defaultTaxIds.includes(taxId);

                return `<option value="${t.id}" ${isDefault ? 'selected' : ''}>${t.name} - ${t.value}%</option>`;
            }).join('')}
                                                                                </select>
                                                                                </td>
                                                                                <td style="width:150px;">
                                                                                <input type="text" name="dynamicFields[${rowCount}][amount]" class="form-control amount" readonly />
                                                                                </td>
                                                                                <td class="text-center align-middle">
                                                                                <a href="javascript:void(0);" onclick="removeRow(${rowCount})" class="text-danger fs-5" title="Remove Row">
                                                                                    <i class="fas fa-trash"></i>
                                                                                </a>
                                                                            </td>

                                                                            </tr>
                                                                            `;
            document.getElementById('productRows').insertAdjacentHTML('beforeend', row);
            $(`#row-${rowCount} .product-select`).select2({
                placeholder: "Select Product",
                width: '100%'
            });

            // If GST is selected, enable taxes, otherwise disable
            const gstValue = document.getElementById('gst').value;
            if (gstValue === 'N') {
                const taxSelect = document.querySelector(`#row-${rowCount} .tax-select`);
                taxSelect.innerHTML = '<option value="no-tax" selected>No Tax</option>';
                taxSelect.disabled = true;
            }
        }

        function addProductToTable(product) {
            rowCount++;
            const row = `
                                                                            <tr id="row-${rowCount}">
                                                                                
                                                                            <td>
                                                                                <div class="d-flex flex-column">
                                                                            <select name="dynamicFields[${rowCount}][product]" class="form-select product-select" 
                                                                            onchange="updateProductDetails(${rowCount})">
                                                                            <option value="">Select Product</option>
                                                                            ${products.map(p => `<option value="${p.id}" ${p.id == product.id ? 'selected' : ''}>${p.code} - ${p.branch.native_name_flag == 'A' ? (p.native_name ?? p.name) : p.name}</option>`).join('')}
                                                                            </select>
                                                                                ${isDescription === 'A' ? `
                                                                                <input type="text" name="dynamicFields[${rowCount}][description]"
                                                                                    style="padding-left:10px !important;" class="form-control mt-1"
                                                                                    id="description-${rowCount}" placeholder="Enter a Description">
                                                                            ` : ''}
                                                                            </div>
                                                                                </td>
                                                                                <td style="width:120px;">
                                                                                <input type="text" name="dynamicFields[${rowCount}][avl_qty]" class="form-control avl-qty" 
                                                                                value="${product.qty}" readonly />
                                                                                </td>
                                                                                <td style="width:120px;">
                                                                                <input type="text" name="dynamicFields[${rowCount}][qty]" class="form-control qty" 
                                                                                value="1" onchange="calculateRowAmount(${rowCount})" 
                                                                                oninput="checkQuantity(${rowCount})" />
                                                                                <div class="invalid-feedback quantity-error" style="display: none;">
                                                                                Quantity exceeds available stock!
                                                                                </div>
                                                                                </td>
                                                                                <td style="width:120px;">
                                                                                <input type="text" name="dynamicFields[${rowCount}][unit_price]" class="form-control unit-price" 
                                                                                value="${product.unit_price}" onchange="calculateRowAmount(${rowCount})" />
                                                                                </td>
                                                                                <td style="min-width: 150px;">
                                                                                <select name="dynamicFields[${rowCount}][tax][]" class="form-select tax-select" multiple
                                                                                style="height: 50px;"
                                                                                onchange="calculateRowAmount(${rowCount})">
                                                                                ${taxes.map(t => {
                const isDefault = defaultTaxIds.includes(t.id);
                const isProductTax = product.taxes ? product.taxes.includes(t.id) : false;
                const shouldSelect = isDefault || isProductTax;
                return `<option value="${t.id}" ${shouldSelect ? 'selected' : ''}>${t.name} - ${t.value}%</option>`;
            }).join('')}
                                                                                </select>
                                                                                </td>
                                                                                <td style="width:150px;">
                                                                                <input type="text" name="dynamicFields[${rowCount}][amount]" class="form-control amount" 
                                                                                value="${product.unit_price}" readonly  />
                                                                                </td>
                                                                                <td class="text-center align-middle">
                                                                                <a href="javascript:void(0);" onclick="removeRow(${rowCount})" class="text-danger fs-5" title="Remove Row">
                                                                                    <i class="fas fa-trash"></i>
                                                                                </a>
                                                                            </td>

                                                                            </tr>
                                                                            `;
            document.getElementById('productRows').insertAdjacentHTML('beforeend', row);
            $(`#row-${rowCount} .product-select`).select2({
                placeholder: "Select Product",
                width: '100%'
            });

            calculateRowAmount(rowCount);
            checkQuantity(rowCount);

            // If GST is selected, enable taxes, otherwise disable
            const gstValue = document.getElementById('gst').value;
            if (gstValue === 'N') {
                const taxSelect = document.querySelector(`#row-${rowCount} .tax-select`);
                Array.from(taxSelect.options).forEach(option => option.selected = false);
                taxSelect.disabled = true;
                calculateRowAmount(rowCount);
            }
        }

        function updateProductDetails(rowId) {
            const row = document.getElementById(`row-${rowId}`);
            const productSelect = row.querySelector('.product-select');
            const productId = productSelect.value;
            const product = products.find(p => p.id == productId);

            // First remove any existing duplicate warnings and highlighting
            removeDuplicateWarnings();
            document.querySelectorAll('.duplicate-row').forEach(row => {
                row.classList.remove('duplicate-row');
            });

            if (product) {
                // Update product details regardless of duplicates
                row.querySelector('.avl-qty').value = product.qty;
                row.querySelector('.qty').value = 1;
                row.querySelector('.unit-price').value = product.unit_price;
                calculateRowAmount(rowId);
                checkQuantity(rowId);

                // Check for duplicates after updating
                checkForDuplicates(rowId);
            }
        }

        function checkForDuplicates(rowId) {
            const row = document.getElementById(`row-${rowId}`);
            const productId = row.querySelector('.product-select').value;

            if (!productId) return;

            const allRows = document.querySelectorAll('#productRows tr');
            let duplicateFound = false;

            allRows.forEach(existingRow => {
                const existingRowId = existingRow.id.split('-')[1];
                if (existingRowId != rowId) {
                    const existingProductId = existingRow.querySelector('.product-select').value;
                    if (existingProductId == productId) {
                        duplicateFound = true;
                        row.classList.add('duplicate-row');
                        existingRow.classList.add('duplicate-row');
                        showDuplicateWarning(row, existingRow);
                    }
                }
            });
            if (duplicateFound) {
                $('.addRow').prop('disabled', true);
                document.getElementById('submit').disabled = true;
            } else {
                $('.addRow').prop('disabled', false);
                document.getElementById('submit').disabled = false;
            }
        }

        // Add event listener to remove warnings when product selection changes
        document.addEventListener('DOMContentLoaded', function () {
            document.querySelectorAll('.product-select').forEach(select => {
                select.addEventListener('change', function () {
                    const rowId = this.closest('tr').id.split('-')[1];
                    // Remove warnings when changing selection
                    removeDuplicateWarnings();
                    document.querySelectorAll('.duplicate-row').forEach(row => {
                        row.classList.remove('duplicate-row');
                    });
                    // Check again if the new selection is a duplicate
                    setTimeout(() => checkForDuplicates(rowId), 10);
                });
            });
        });

        function showDuplicateWarning(row1, row2) {
            // Only add if not already present
            if (!row1.querySelector('.duplicate-warning')) {
                const warning1 = document.createElement('div');
                warning1.className = 'duplicate-warning text-danger small mt-1';
                warning1.innerHTML = '<i class="fas fa-exclamation-triangle"></i> Duplicate product';
                row1.querySelector('td').appendChild(warning1);
            }

            if (!row2.querySelector('.duplicate-warning')) {
                const warning2 = document.createElement('div');
                warning2.className = 'duplicate-warning text-danger small mt-1';
                warning2.innerHTML = '<i class="fas fa-exclamation-triangle"></i> Duplicate product';
                row2.querySelector('td').appendChild(warning2);
            }
        }

        function removeDuplicateWarnings() {
            document.querySelectorAll('.duplicate-warning').forEach(warning => {
                warning.remove();
            });
        }

        function checkQuantity(rowId) {

            const row = document.getElementById(`row-${rowId}`);
            const qtyInput = row.querySelector('.qty');
            const avlQty = parseFloat(row.querySelector('.avl-qty').value) || 0;
            const qty = parseFloat(qtyInput.value) || 0;
            const errorElement = row.querySelector('.quantity-error');
            if (isAvl != 'A') {
                if (qty > avlQty) {
                    qtyInput.classList.add('is-invalid');
                    errorElement.style.display = 'block';
                    hasQuantityError = true;
                    return false;
                } else {
                    qtyInput.classList.remove('is-invalid');
                    errorElement.style.display = 'none';

                    // Check if all other rows are also valid
                    hasQuantityError = false;
                    document.querySelectorAll('#productRows tr').forEach(r => {
                        const rQtyInput = r.querySelector('.qty');
                        const rAvlQty = parseFloat(r.querySelector('.avl-qty').value) || 0;
                        const rQty = parseFloat(rQtyInput?.value) || 0;

                        if (rQty > rAvlQty) {
                            hasQuantityError = true;
                        }
                    });

                    return true;
                }
            }
        }

        function calculateRowAmount(rowId) {
            const row = document.getElementById(`row-${rowId}`);
            const qty = parseFloat(row.querySelector('.qty').value) || 0;
            const unitPrice = parseFloat(row.querySelector('.unit-price').value) || 0;
            const amount = qty * unitPrice;

            // Calculate tax
            const taxSelect = row.querySelector('.tax-select');
            const selectedTaxes = Array.from(taxSelect.selectedOptions).map(opt => parseInt(opt.value));
            let taxRate = 0;

            selectedTaxes.forEach(taxId => {
                const tax = taxes.find(t => t.id == taxId);
                if (tax) taxRate += tax.value;
            });

            const taxAmount = amount * (taxRate / 100);
            const totalWithTax = amount + taxAmount;

            row.querySelector('.amount').value = amount.toFixed(2);
            calculateTotal();
        }

        function calculateTotal() {
            let subTotal = 0;
            let totalTax = 0;
            let totalQuantity = 0;
            const redeem = parseFloat($('#redeem_points').val()) * pointValue || 0;


            document.querySelectorAll('#productRows tr').forEach(row => {
                const amount = parseFloat(row.querySelector('.amount').value) || 0;
                const qty = parseFloat(row.querySelector('.qty').value) || 0;
                const unitPrice = parseFloat(row.querySelector('.unit-price').value) || 0;
                const rowAmount = qty * unitPrice;

                totalQuantity += qty;
                subTotal += rowAmount;

                // Calculate tax for this row
                const taxSelect = row.querySelector('.tax-select');
                const selectedTaxes = Array.from(taxSelect.selectedOptions).map(opt => parseInt(opt.value));
                let taxRate = 0;

                selectedTaxes.forEach(taxId => {
                    const tax = taxes.find(t => t.id == taxId);
                    if (tax) taxRate += tax.value;
                });

                totalTax += rowAmount * (taxRate / 100);
            });

            // Calculate discount
            const discountType = document.getElementById('discount_type').value;
            const discountValue = parseFloat(document.getElementById('discount').value) || 0;
            let discountAmount = 0;

            var subtotalWithTax = subTotal + totalTax;

            if (discountType == 1) {
                discountAmount = discountValue;
            } else if (discountType == 2) {
                discountAmount = subtotalWithTax * (discountValue / 100);
            }

            let totals = subtotalWithTax - discountAmount;
            total = totals - redeem;

            // Update display
            document.getElementById('subTotalDisplay').textContent = subTotal.toFixed(2) + ' ₹';
            document.getElementById('discountDisplay').textContent = discountAmount.toFixed(2) + ' ₹';
            document.getElementById('taxDisplay').textContent = totalTax.toFixed(2) + ' ₹';
            document.getElementById('totalDisplay').textContent = Math.floor(total).toFixed(2) + ' ₹';
            document.getElementById('totalQuantity').textContent = totalQuantity;

            // Update hidden fields
            document.getElementById('sub_total').value = subTotal.toFixed(2);
            document.getElementById('discount_amt').value = discountAmount.toFixed(2);
            document.getElementById('tax').value = totalTax.toFixed(2);
            document.getElementById('total_amt').value = Math.floor(total).toFixed(2);
        }

        function toggleTaxes() {
            const gstValue = document.getElementById('gst').value;
            const taxSelects = document.querySelectorAll('.tax-select');

            taxSelects.forEach(select => {
                if (gstValue === 'N') {
                    select.innerHTML = '<option value="no-tax" selected>No Tax</option>';
                    select.disabled = true;
                } else {
                    select.disabled = false;
                    select.innerHTML = taxes.map(t => {
                        const isDefault = defaultTaxIds.includes(t.id);
                        return `<option value="${t.id}" ${isDefault ? 'selected' : ''}>${t.name} - ${t.value}%</option>`;
                    }).join('');
                }
            });

            calculateTotal();
        }

        function toggleNotesAndTerms(baseLabel) {
            const section = document.getElementById('notesTermsSection');
            const btn = document.getElementById('notesTermsBtn');

            const isVisible = section.style.display === 'flex' || section.style.display === 'block';

            section.style.display = isVisible ? 'none' : 'flex';

            if (!isVisible) {
                btn.innerHTML = `<i class="fas fa-minus"></i> Remove ${baseLabel}`;
            } else {
                btn.innerHTML = `<i class="fas fa-plus"></i> ${baseLabel}`;
            }
        }

        function removeRow(rowId) {
            document.getElementById(`row-${rowId}`).remove();
            calculateTotal();

            // After removing a row, check if we still have quantity errors
            hasQuantityError = false;
            document.querySelectorAll('#productRows tr').forEach(r => {
                const rQtyInput = r.querySelector('.qty');
                const rAvlQty = parseFloat(r.querySelector('.avl-qty').value) || 0;
                const rQty = parseFloat(rQtyInput?.value) || 0;

                if (rQty > rAvlQty) {
                    hasQuantityError = true;
                }
            });
        }

        // Form submission validation
        function validateForm(event) {
            // First check all quantities
            document.querySelectorAll('#productRows tr').forEach(row => {
                const rowId = row.id.split('-')[1];
                checkQuantity(rowId);
            });

            if (hasQuantityError) {
                event.preventDefault();
                Swal.fire({
                    icon: 'error',
                    title: 'Quantity Error',
                    text: 'Please fix quantity errors before submitting. Some items have quantity greater than available stock.',
                    confirmButtonText: 'OK',
                });
                return false;
            }

            return true;
        }

        // Initialize on page load
        $(document).ready(function () {
            $('#client_num_select').select2({
                placeholder: "Search or type a number",
                allowClear: true,
                tags: true,
                tokenSeparators: [',', ' '],
                width: '100%',
                createTag: function (params) {
                    if (params.term.trim() === '') {
                        return null;
                    }

                    return {
                        id: params.term,
                        text: params.term
                    };
                }
            });

            document.getElementById('invoice_date').valueAsDate = new Date();
            document.getElementById('due_date').valueAsDate = new Date();

            document.getElementById('discount_type').addEventListener('change', function () {
                document.getElementById('discount').readOnly = !this.value;
                calculateTotal();
            });

            // Add form submission handler
            document.querySelector('form').addEventListener('submit', validateForm);
        });

        $(document).ready(function () {
            toggleTaxes();

            $('#gst').on('change', function () {
                toggleTaxes();
            });
        });

        $(document).ready(function () {
            let existingClientNumbers = $("#client_num_select option").map(function () {
                return $(this).val();
            }).get();

            $(document).ready(function () {
                let existingClientNumbers = $("#client_num_select option").map(function () {
                    return $(this).val();
                }).get();

                $("#client_num_select").on("change", function () {
                    let selectedNumbers = $(this).val() || [];
                    let errorElement = $("#client_num_error");

                    let selectedOption = $(this).find('option:selected').first();
                    let clientID = selectedOption.data('clientid');
                    $('.redeem_points').hide();

                    if (isLoyalty == 'A') {
                        if (clientID) {
                            $.ajax({
                                url: '<?php echo e(route('single-client')); ?>',
                                type: 'GET',
                                data: { clientID: clientID },
                                success: function (data) {
                                    $('.redeem_points').hide();

                                    let earnPoints = data.earnPoints;
                                    redeemPoints = data.redeemPoints;
                                    avlPoint = data.availablePoints;

                                    $('#earnPoints').text(earnPoints + ' ');
                                    $('#redeemPoints').text(redeemPoints + ' ');
                                    $('#availablePoints').text(avlPoint + ' ');
                                    $('#earnPoints, #redeemPoints, #availablePoints').append('<i class="fa-solid fa-coins text-warning"></i>');

                                    document.getElementById('earn_point').value = earnPoints;
                                    document.getElementById('redeem_point').value = redeemPoints;
                                    document.getElementById('available_point').value = avlPoint;

                                    $('.redeem_points').show();


                                },
                                error: function (xhr) {
                                    console.log(xhr);
                                }
                            });
                        }
                    } else {
                        if (clientID) {
                            $.ajax({
                                url: '<?php echo e(route('single-client')); ?>',
                                type: 'GET',
                                data: { clientID: clientID },
                                success: function (data) {
                                    console.log(data);

                                    $('.due_amount').html('Due Amount: <strong>₹ ' + data.dueAmount.toFixed(2) + '</strong>');

                                    // Optional: Add warning class if due amount > 0
                                    if (data.dueAmount > 0) {
                                        $('.due_amount').removeClass('bg-secondary').addClass('bg-warning text-dark');
                                    }
                                },
                                error: function (xhr) {
                                    console.log(xhr);
                                }
                            });
                        }
                    }
                    // Check if empty
                    if (selectedNumbers.length === 0) {
                        errorElement.text("Please select or enter a client number").show();
                        return;
                    } else {
                        errorElement.hide();
                    }

                    let hasNewNumber = selectedNumbers.some(num => !existingClientNumbers.includes(num));

                    if (hasNewNumber) {
                        $('.redeem_points').hide();
                        $("#client_name").prop("required", true);
                        $("#client_name_error").text("Please enter Client Name").show();
                    }
                    $('#client_name').on('input', function () {
                        let name = $(this).val().trim();
                        if (name !== '') {
                            $("#client_name_error").text('').hide();
                            $(this).removeClass('is-invalid');
                        } else {
                            $("#client_name_error").text("Please enter Client Name").show();
                            $(this).addClass('is-invalid');
                        }
                    });
                });

                $('form').on('submit', function (e) {
                    let selectedNumbers = $("#client_num_select").val() || [];
                    let errorElement = $("#client_num_error");

                    if (selectedNumbers.length === 0) {
                        errorElement.text("Please select or enter a client number").show();
                        e.preventDefault();

                        // Scroll to the error
                        $('html, body').animate({
                            scrollTop: errorElement.offset().top - 100
                        }, 500);

                        return false;
                    }
                    return true;
                });

                $("#client_name").on("input", function () {
                    if ($(this).val().trim() !== "") {
                        $("#client_name_error").hide();
                    }
                });
            });
            $('#redeem_points').on('change input', function () {
                let entered_points = parseFloat($(this).val()) || 0;


                let container = $(this).closest('.current_point');
                let errorElement = container.find('.error-feedback');

                errorElement.text('').hide();
                $(this).removeClass('is-invalid');

                if (entered_points > avlPoint) {
                    errorElement.text('Redeem points cannot exceed available points').show();
                    $(this).addClass('is-invalid');
                    $(this).val(avlPoint);
                    return false;
                }
                currentPoint = avlPoint - entered_points;
                redeemedPoints = redeemPoints + entered_points;
                $('#availablePoints').text(currentPoint + ' ');
                $('#redeemPoints').text(redeemedPoints + ' ');
                $('#availablePoints,#redeemPoints').append('<i class="fa-solid fa-coins text-warning"></i>');
                calculateTotal();
            });
        });
        $(document).ready(function () {
            function calculatePaymentBreakdown() {
                let total_amount = parseFloat($('#total_amt').val()) || 0;
                let tendered_amount = parseFloat($('#tendered_amount').val()) || 0;
                let upi_amount = parseFloat($('#upi').val()) || 0;
                let online_amount = parseFloat($('#online').val()) || 0;
                let cash_amount = parseFloat($('#cash').val()) || 0;

                let digital_payments = upi_amount + online_amount;

                let remaining_after_digital = total_amount - digital_payments;
                if (remaining_after_digital < 0) remaining_after_digital = 0;

                let extra_amount = 0;

                if (tendered_amount > 0) {
                    let cash_to_take = Math.min(tendered_amount, remaining_after_digital);
                    $('#cash').val(cash_to_take.toFixed(2));
                    cash_amount = cash_to_take;

                    extra_amount = tendered_amount - cash_amount;

                } else {
                    let total_paid = digital_payments + cash_amount;
                    extra_amount = total_paid - total_amount;
                }

                if (extra_amount < 0) extra_amount = 0;

                $('.extra_amount').text('Extra Amount: ₹ ' + extra_amount.toFixed(2));
            }

            $(document).on('input', '#tendered_amount, #upi, #online, #cash', function () {
                calculatePaymentBreakdown();
            });

            $(document).on('change', function () {
                calculatePaymentBreakdown();
            });
        });


    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/invoices/add.blade.php ENDPATH**/ ?>