

<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4 mx-4">
                    <!-- Card Header -->
                    <div class="card-header pb-0">
                        <div class="d-flex flex-row justify-content-between">
                            <div>
                                <h5 class="mb-0">Invoices</h5>
                            </div>
                             <?php if(Auth::user()->user_flg !== 'C'): ?>
                            <a href="<?php echo e(route('invoice-add')); ?>" class="btn bg-gradient-primary btn-sm mb-0">+&nbsp; New
                                Invoice</a>
                                <?php endif; ?>
                        </div>
                    </div>
                    <div class="card-body px-0 pt-0 pb-2">

                        <div class="table-responsive p-0">
                            <table class="table align-items-center mb-0 table-hover" id="myTable2">
                                <thead>
                                    <tr>
                                          <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Action</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            ID</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Client</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Invoice Date</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Due Date</th>
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Amount</th>                                    
                                        <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                           Payment Status</th>
                                           <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                           Delivery Status</th>
                                             <th
                                            class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2">
                                            Created by</th>                                      
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>                                   
                                        <tr>
                                            <td >
                                                <?php if(Auth::user()->user_flg !== 'C'): ?>
                                                <a href="<?php echo e(route('invoice-edit', $invoice->id)); ?>">
                                                    <i class="fa-solid fa-pen-to-square text-secondary"></i>
                                                </a>
                                                <form action="<?php echo e(route('invoice-delete', $invoice->id)); ?>" method="POST"
                                                    class="d-inline" id="delete-form-<?php echo e($invoice->id); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>                                                    
                                                        <i class="cursor-pointer fas fa-trash text-secondary ms-2" onclick="confirmDelete(<?php echo e($invoice->id); ?>)"></i>                                                   
                                                </form>
                                                <?php endif; ?>
                                                <?php if(Auth::user()->user_flg == 'C'): ?>
                                                <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#updateStatusModal"
    data-id="<?php echo e($invoice->id); ?>" data-status="<?php echo e($invoice->delivery_status); ?>">  <i class="fa-solid fa-pen-to-square text-secondary"></i></a>
                                                <?php endif; ?>
                                                
                                                <a href="<?php echo e(route('pdf',$invoice->id)); ?>">
                                                    <i class="fa-solid fa-download text-secondary ms-2"></i>
                                                </a>
                                            </td>
                                            <td>
                                                <p class="text-xs font-weight-bold mb-0"><?php echo e($invoice->invoice_id); ?></p>
                                            </td>
                                           <td>
                                                <p class="text-xs font-weight-bold mb-0">
                                                    <?php echo e(Str::limit($invoice->client->user->name . ' ' . $invoice->client->user->last_name, 150)); ?>

                                                </p>
                                            </td>

                                            <td>
                                                <p class="text-xs font-weight-bold mb-0">
                                                    <?php echo e($invoice->invoice_date ? \Carbon\Carbon::parse($invoice->invoice_date)->format('d-m-Y') : ''); ?>

                                                </p>
                                            </td>
                                            <td>
                                                <p class="text-xs font-weight-bold mb-0">
                                                    <?php echo e($invoice->due_date ? \Carbon\Carbon::parse($invoice->due_date)->format('d-m-Y') : ''); ?>

                                                </p>
                                            </td>
                                            <td>
                                                <p class="text-xs font-weight-bold mb-0">
                                                    <?php echo e($invoice->final_amount); ?>

                                                </p>
                                            </td>                                           
                                            <td>
                                                <p class="text-xs font-weight-bold mb-0">
                                                    <?php
                                                        $status = optional($payment_status->firstWhere('id', $invoice->status))->name;
                                                        $badgeClass = match($status) {
                                                            'Paid' => 'bg-success',
                                                            'Partially Paid' => 'bg-warning text-dark',
                                                            'Unpaid' => 'bg-danger',                                                          
                                                        };
                                                    ?>
                                                
                                                    <span class="badge <?php echo e($badgeClass); ?>">
                                                        <?php echo e($status ?? 'Unknown'); ?>

                                                    </span>
                                                </p>
                                            </td>
                                            <td>
                                                <p class="text-xs font-weight-bold mb-0">                                                   
                                                <?php if($invoice->delivery_status == 1): ?>
                                                     <span class="badge bg-info">
                                                        In Progress
                                                    </span>
                                                <?php elseif($invoice->delivery_status == 2): ?>
                                                    <span class="badge bg-success">
                                                        Delivered
                                                    </span>
                                                    <?php else: ?>
                                                    <span class="badge bg-secondary">
                                                        Unknown
                                                    </span>
                                                <?php endif; ?>                                                  
                                                </p>
                                            </td>
                                            <td><?php echo e($invoice->createdBy->name ?? ''.' '. $invoice->createdBy->last_name ?? ''); ?></td>
                                            
                                        </tr>                                    
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="updateStatusModal" tabindex="-1" aria-labelledby="updateStatusModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="POST" action="<?php echo e(route('invoice-updateDeliveryStatus')); ?>">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="invoice_id" id="modal-invoice-id">

        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="updateStatusModalLabel">Update Delivery Status</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>

          <div class="modal-body">
            <div class="mb-3">
              <label for="delivery_status" class="form-label">Select Status</label>
              <select class="form-select" name="delivery_status" id="modal-delivery-status" required>
                <option value="">-- Select Status --</option>
                <option value="1">In Progress</option>
                <option value="2">Delivered</option>              
              </select>
            </div>
          </div>

          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary">Update</button>
          </div>
        </div>
    </form>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    function confirmDelete(id) {
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, delete it!',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('delete-form-' + id).submit();
            }
        });
    }
    const updateStatusModal = document.getElementById('updateStatusModal');
    updateStatusModal.addEventListener('show.bs.modal', function (event) {
        const button = event.relatedTarget;
        const invoiceId = button.getAttribute('data-id');
        const currentStatus = button.getAttribute('data-status');

        document.getElementById('modal-invoice-id').value = invoiceId;
        document.getElementById('modal-delivery-status').value = currentStatus;
    });

    $(document).ready(function () {
            $('#myTable2').DataTable({
                "order": [],
                layout: {
                    topStart: {
                        buttons: ['excel', 'pdf', 'print', 'colvis','pageLength']
                    },
                },
                lengthMenu: [ [10, 250, 500, 750,1000, -1], [10, 250, 500, 750, 1000, "All"] ]
            });
        });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/invoices/index.blade.php ENDPATH**/ ?>