<?php $__env->startSection('content'); ?>
    <div class="page-header section-height-75">
        <div class="container">
            <div class="row">
                <div class="col-xl-4 col-lg-5 col-md-6 d-flex flex-column mx-auto">
                    <div class="card card-plain mt-8">
                        <div class="card-header pb-0 text-left bg-transparent">
                            <h3 class="font-weight-bolder text-info text-gradient">Select Company and Branch</h3>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="<?php echo e(route('setup-submit')); ?>" role="form text-left">
                                <?php echo csrf_field(); ?>
                                <?php if(Auth::user()->user_flg !='C'): ?>
                                <div class="mb-3">
                                    <label for="company">Company</label>
                                    <div class="<?php $__errorArgs = ['company'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>border border-danger rounded-3 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                        <select id="company" name="company" class="form-select"
                                            onchange="loadBranches(this.value)">
                                            <option value="">Select Company</option>
                                            <?php $__empty_1 = true; $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <option value="<?php echo e($data->id); ?>" <?php echo e(old('company') == $data->id ? 'selected' : ''); ?>>
                                                    <?php echo e($data->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <option value="">No company found</option>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                    <?php $__errorArgs = ['company'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <?php else: ?>
                                <input type="hidden" name="company" id="company" value="<?php echo e(Auth::user()->branch->company_id); ?>">
                                <?php endif; ?>                                
                                <div class="mb-3">
                                    <label for="branch">Branch</label>
                                    <div class="<?php $__errorArgs = ['branch'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>border border-danger rounded-3 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                        <select id="branch" name="branch" class="form-select" <?php echo e(empty(old('company')) ? 'disabled' : ''); ?>>
                                            <option value="">Select Branch</option>
                                            <?php if(old('company')): ?>
                                             
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                    <?php $__errorArgs = ['branch'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="text-center">
                                    <button type="submit" class="btn bg-gradient-info w-100 mt-4 mb-0">Proceed</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="oblique position-absolute top-0 h-100 d-md-block d-none me-n8">
                        <div class="oblique-image bg-cover position-absolute fixed-top ms-auto h-100 z-index-0 ms-n6"
                            style="background-image:url('<?php echo e(getFileUrl($image->logo)); ?>')"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>

    <script>
        function loadBranches(companyId) {
            const branchSelect = document.getElementById('branch');
            branchSelect.innerHTML = '<option value="">Loading branches...</option>';

            if (!companyId) {
                branchSelect.innerHTML = '<option value="">Select Branch</option>';
                branchSelect.disabled = true;
                return;
            }

            fetch(`/setup/branches/${companyId}`)
                .then(response => response.json())
                .then(data => {
                    branchSelect.innerHTML = '<option value="">Select Branch</option>';

                    data.branches.forEach(branch => {
                        const option = document.createElement('option');
                        option.value = branch.id;
                        option.textContent = branch.name;
                        branchSelect.appendChild(option);
                    });

                    branchSelect.disabled = false;
                })
                .catch(error => {
                    branchSelect.innerHTML = '<option value="">Unable to loading branches</option>';
                    console.error('Error:', error);
                });
        }

        document.addEventListener('DOMContentLoaded', function () {
            const companyId = document.getElementById('company').value;
            if (companyId) {
                loadBranches(companyId);
            }
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.layoutapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/auth/setup.blade.php ENDPATH**/ ?>